/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.typeadapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.leralix.tan.war.legacy.wargoals.CaptureFortWarGoal;
import org.leralix.tan.war.legacy.wargoals.CaptureLandmarkWarGoal;
import org.leralix.tan.war.legacy.wargoals.ConquerWarGoal;
import org.leralix.tan.war.legacy.wargoals.LiberateWarGoal;
import org.leralix.tan.war.legacy.wargoals.SubjugateWarGoal;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class WargoalTypeAdapter
implements JsonDeserializer<WarGoal>,
JsonSerializer<WarGoal> {
    @Override
    public WarGoal deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String type;
        JsonObject jsonObject = json.getAsJsonObject();
        return switch (type = jsonObject.get("type").getAsString()) {
            case "ConquerWarGoal" -> (WarGoal)context.deserialize(jsonObject, (Type)((Object)ConquerWarGoal.class));
            case "SubjugateWarGoal" -> (WarGoal)context.deserialize(jsonObject, (Type)((Object)SubjugateWarGoal.class));
            case "LiberateWarGoal" -> (WarGoal)context.deserialize(jsonObject, (Type)((Object)LiberateWarGoal.class));
            case "CaptureLandmarkWarGoal" -> {
                if (!jsonObject.has("landmarkToCaptureID") || jsonObject.get("landmarkToCaptureID").isJsonNull()) {
                    yield new ConquerWarGoal(1);
                }
                String landmarkID = jsonObject.get("landmarkToCaptureID").getAsString();
                if (landmarkID == null || landmarkID.isEmpty()) {
                    yield new ConquerWarGoal(1);
                }
                yield (WarGoal)context.deserialize(jsonObject, (Type)((Object)CaptureLandmarkWarGoal.class));
            }
            case "CaptureFortWarGoal" -> {
                if (!jsonObject.has("fortToCaptureID") || jsonObject.get("fortToCaptureID").isJsonNull()) {
                    yield new ConquerWarGoal(1);
                }
                String fortID = jsonObject.get("fortToCaptureID").getAsString();
                if (fortID == null || fortID.isEmpty()) {
                    yield new ConquerWarGoal(1);
                }
                yield (WarGoal)context.deserialize(jsonObject, (Type)((Object)CaptureFortWarGoal.class));
            }
            default -> throw new JsonParseException("Unknown type: " + type);
        };
    }

    @Override
    public JsonElement serialize(WarGoal src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = context.serialize(src, src.getClass()).getAsJsonObject();
        result.add("type", new JsonPrimitive(src.getClass().getSimpleName()));
        return result;
    }
}

