/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.tasks;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.events.newsletter.NewsletterStorage;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.file.ArchiveUtil;

public class DailyTasks {
    private final Calendar calendar;
    private final int hourTime;
    private final int minuteTime;

    public DailyTasks(int hourTime, int minuteTime) {
        this.hourTime = hourTime;
        this.minuteTime = minuteTime;
        this.calendar = new GregorianCalendar();
    }

    public void scheduleMidnightTask() {
        new BukkitRunnable(){

            public void run() {
                if (DailyTasks.this.calendar.get(11) == DailyTasks.this.hourTime && DailyTasks.this.calendar.get(12) == DailyTasks.this.minuteTime) {
                    DailyTasks.executeMidnightTasks();
                }
            }
        }.runTaskTimer((Plugin)TownsAndNations.getPlugin(), 0L, 1200L);
    }

    public static void executeMidnightTasks() {
        DailyTasks.propertyRent();
        for (TownData town : TownDataStorage.getInstance().getAll().values()) {
            town.executeTasks();
        }
        for (RegionData regionData : RegionDataStorage.getInstance().getAll().values()) {
            regionData.executeTasks();
        }
        DailyTasks.clearOldTaxes();
        DailyTasks.updatePlayerUsernames();
        NewsletterStorage.getInstance().clearOldNewsletters();
        if (ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getBoolean("enableMidnightGenerateResource", true)) {
            LandmarkStorage.getInstance().generateAllResources();
        }
        ArchiveUtil.archiveFiles();
    }

    private static void updatePlayerUsernames() {
        for (ITanPlayer player : PlayerDataStorage.getInstance().getAll().values()) {
            player.clearName();
        }
    }

    private static void propertyRent() {
        for (TownData town : TownDataStorage.getInstance().getAll().values()) {
            for (PropertyData property : town.getProperties()) {
                if (!property.isRented()) continue;
                property.payRent();
            }
        }
    }

    public static void clearOldTaxes() {
    }
}

