/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade.rewards.numeric;

import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.upgrade.rewards.IndividualStat;

public abstract class NumericStat
extends IndividualStat {
    protected final int maxAmount;
    protected final boolean isUnlimited;

    protected NumericStat(int maxAmount, boolean isUnlimited) {
        this.maxAmount = maxAmount;
        this.isUnlimited = isUnlimited;
    }

    @Override
    public FilledLang getStatReward(LangType langType, int level, int maxLevel) {
        if (this.isUnlimited) {
            if (level == 0) {
                return Lang.UPGRADE_LINE_INFINITY_LOCKED.get(this.getStatName().get(langType, new String[0]));
            }
            return Lang.UPGRADE_LINE_INFINITY_UNLOCKED.get(this.getStatName().get(langType, new String[0]));
        }
        if (level >= maxLevel) {
            return Lang.UPGRADE_LINE_INT_MAX.get(this.getStatName().get(langType, new String[0]), this.getMathSign(this.maxAmount * maxLevel));
        }
        return Lang.UPGRADE_LINE_INT.get(this.getStatName().get(langType, new String[0]), this.getMathSign(this.maxAmount * level), this.getMathSign(this.maxAmount));
    }

    @Override
    public FilledLang getStatReward(LangType langType) {
        if (this.isUnlimited) {
            return Lang.UPGRADE_LINE_INFINITY_UNLOCKED.get(this.getStatName().get(langType, new String[0]));
        }
        return Lang.UPGRADE_LINE_INT_MAX.get(this.getStatName().get(langType, new String[0]), this.getMathSign(this.maxAmount));
    }

    public boolean canDoAction(int value) {
        if (this.isUnlimited) {
            return true;
        }
        return value <= this.maxAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public boolean isUnlimited() {
        return this.isUnlimited;
    }
}

