/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade.rewards.numeric;

import java.util.List;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.service.requirements.IndividualRequirement;
import org.leralix.tan.gui.service.requirements.PropertyCapRequirement;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.upgrade.rewards.AggregatableStat;
import org.leralix.tan.upgrade.rewards.numeric.NumericStat;

public class PropertyCap
extends NumericStat
implements AggregatableStat<PropertyCap> {
    public PropertyCap() {
        super(0, false);
    }

    public PropertyCap(int maxAmount, boolean isUnlimited) {
        super(maxAmount, isUnlimited);
    }

    @Override
    public PropertyCap scale(int factor) {
        return new PropertyCap(this.maxAmount * factor, this.isUnlimited);
    }

    @Override
    public PropertyCap aggregate(List<PropertyCap> stats) {
        int totalCap = 0;
        boolean unlimitedFound = false;
        for (PropertyCap stat : stats) {
            if (stat.isUnlimited) {
                unlimitedFound = true;
            }
            totalCap += stat.maxAmount;
        }
        return new PropertyCap(totalCap, unlimitedFound);
    }

    public IndividualRequirement getRequirement(TownData townData) {
        return new PropertyCapRequirement(townData, this.maxAmount);
    }

    @Override
    public Lang getStatName() {
        return Lang.PROPERTY_CAP;
    }
}

