/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade.rewards.numeric;

import java.util.List;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.upgrade.rewards.AggregatableStat;
import org.leralix.tan.upgrade.rewards.numeric.NumericStat;

public class TownPlayerCap
extends NumericStat
implements AggregatableStat<TownPlayerCap> {
    public TownPlayerCap() {
        super(0, false);
    }

    public TownPlayerCap(int maxAmount, boolean isUnlimited) {
        super(maxAmount, isUnlimited);
    }

    @Override
    public TownPlayerCap scale(int factor) {
        return new TownPlayerCap(this.maxAmount * factor, this.isUnlimited);
    }

    @Override
    public TownPlayerCap aggregate(List<TownPlayerCap> stats) {
        int totalCap = 0;
        boolean unlimitedFound = false;
        for (TownPlayerCap stat : stats) {
            if (stat.isUnlimited) {
                unlimitedFound = true;
            }
            totalCap += stat.maxAmount;
        }
        return new TownPlayerCap(totalCap, unlimitedFound);
    }

    @Override
    public Lang getStatName() {
        return Lang.PLAYER_CAP;
    }
}

