/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.constants;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class RelationConstant {
    private final boolean canPvP;
    private final int trucePeriod;
    private final boolean canInteractWithProperty;
    private final boolean canAccessTerritory;
    private final Set<String> blockedCommands;

    public RelationConstant(ConfigurationSection configurationSection) {
        this.canPvP = configurationSection.getBoolean("enablePvP", true);
        this.trucePeriod = configurationSection.getInt("truce_period", 0);
        this.canInteractWithProperty = configurationSection.getBoolean("canInteractWithProperty", true);
        this.canAccessTerritory = configurationSection.getBoolean("canAccessTerritory", true);
        this.blockedCommands = new HashSet<String>(configurationSection.getStringList("blockedCommands"));
    }

    public boolean canPvP() {
        return this.canPvP;
    }

    public int trucePeriod() {
        return this.trucePeriod;
    }

    public boolean canInteractWithProperty() {
        return this.canInteractWithProperty;
    }

    public boolean canAccessTerritory() {
        return this.canAccessTerritory;
    }

    public Set<String> getBlockedCommands() {
        return this.blockedCommands;
    }
}

