/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.deprecated;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;

public class HeadUtils {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    private HeadUtils() {
        throw new IllegalStateException("Utility class");
    }

    @NotNull
    public static ItemStack getPlayerHead(String headName, OfflinePlayer offlinePlayer, List<String> lore) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)playerHead.getItemMeta();
        if (skullMeta == null) {
            return playerHead;
        }
        skullMeta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + headName);
        skullMeta.setOwningPlayer(offlinePlayer);
        if (lore != null) {
            skullMeta.setLore(lore);
        }
        playerHead.setItemMeta((ItemMeta)skullMeta);
        return playerHead;
    }

    @NotNull
    public static ItemStack getPlayerHead(String headName, OfflinePlayer offlinePlayer, String ... loreLines) {
        List<String> lore = List.of(loreLines);
        return HeadUtils.getPlayerHead(headName, offlinePlayer, lore);
    }

    @NotNull
    public static ItemStack getPlayerHead(OfflinePlayer offlinePlayer, String ... loreLines) {
        List<String> lore = List.of(loreLines);
        return HeadUtils.getPlayerHead(offlinePlayer.getName(), offlinePlayer, lore);
    }

    @NotNull
    public static ItemStack getPlayerHead(String headName, OfflinePlayer offlinePlayer) {
        return HeadUtils.getPlayerHead(headName, offlinePlayer, (List<String>)null);
    }

    @NotNull
    public static ItemStack getPlayerHead(OfflinePlayer offlinePlayer) {
        return HeadUtils.getPlayerHead(offlinePlayer.getName(), offlinePlayer);
    }

    @NotNull
    public static ItemStack makeSkullB64(@NotNull String name, @NotNull String base64EncodedString, List<String> lore) {
        return HeadUtils.makeSkullURL(name, HeadUtils.getUrlFromBase64(base64EncodedString), lore);
    }

    @NotNull
    public static ItemStack makeSkullURL(@NotNull String name, @NotNull String url, String ... lore) {
        return HeadUtils.makeSkull(name, HeadUtils.getProfile(HeadUtils.createURL(url)), List.of(lore));
    }

    @NotNull
    public static ItemStack makeSkullURL(@NotNull String name, @NotNull URL url, List<String> lore) {
        return HeadUtils.makeSkull(name, HeadUtils.getProfile(url), lore);
    }

    @NotNull
    public static ItemStack makeSkull(@NotNull String name, @NotNull PlayerProfile profile, List<String> lore) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setOwnerProfile(profile);
        meta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + name);
        if (lore != null) {
            meta.setLore(lore);
        }
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private static PlayerProfile getProfile(URL url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        textures.setSkin(url);
        profile.setTextures(textures);
        return profile;
    }

    @NotNull
    public static URL getUrlFromBase64(@NotNull String base64) {
        String decoded = new String(Base64.getDecoder().decode(base64));
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(decoded).getAsJsonObject();
        String url = json.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
        return HeadUtils.createURL(url);
    }

    private static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            try {
                return new URL("http://textures.minecraft.net/texture/e7f9c6fef2ad96b3a5465642ba954671be1c4543e2e25e56aef0a47d5f1f");
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException("Invalid URL: " + url);
            }
        }
    }

    @NotNull
    public static ItemStack makeSkullB64(@NotNull String name, @NotNull String base64EncodedString) {
        return HeadUtils.makeSkullB64(name, base64EncodedString, (List<String>)null);
    }

    @NotNull
    public static ItemStack makeSkullB64(@NotNull String name, @NotNull String base64EncodedString, String ... loreLines) {
        List<String> lore = List.of(loreLines);
        return HeadUtils.makeSkullB64(name, base64EncodedString, lore);
    }

    @NotNull
    public static ItemStack makeSkullB64(@NotNull String name, @NotNull String base64EncodedString, List<String> lore, String ... loreLines) {
        List<String> lore2 = List.of(loreLines);
        lore.addAll(lore2);
        return HeadUtils.makeSkullB64(name, base64EncodedString, lore);
    }

    public static ItemStack getRegionIcon(RegionData regionData, LangType langType) {
        ItemStack icon = regionData.getIcon();
        ItemMeta meta = icon.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + regionData.getName());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Lang.GUI_REGION_INFO_DESC0.get(langType, regionData.getDescription()));
            lore.add(Lang.GUI_REGION_INFO_DESC1.get(langType, regionData.getCapital().getName()));
            lore.add(Lang.GUI_REGION_INFO_DESC2.get(langType, Integer.toString(regionData.getNumberOfTownsIn())));
            lore.add(Lang.GUI_REGION_INFO_DESC3.get(langType, Integer.toString(regionData.getTotalPlayerCount())));
            lore.add(Lang.GUI_REGION_INFO_DESC4.get(langType, Double.toString(regionData.getBalance())));
            lore.add(Lang.GUI_REGION_INFO_DESC5.get(langType, Integer.toString(regionData.getNumberOfClaimedChunk())));
            meta.setLore(lore);
            icon.setItemMeta(meta);
        }
        return icon;
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, String ... loreLines) {
        List<String> lore = List.of(loreLines);
        return HeadUtils.createCustomItemStack(itemMaterial, itemName, lore);
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, List<String> lore, String ... loreLines) {
        List<String> lore2 = List.of(loreLines);
        lore.addAll(lore2);
        return HeadUtils.createCustomItemStack(itemMaterial, itemName, lore2);
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, List<String> lore) {
        ItemStack item = new ItemStack(itemMaterial);
        return HeadUtils.createCustomItemStack(item, itemName, lore);
    }

    public static ItemStack createCustomItemStack(ItemStack item, String itemName, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + itemName);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createCustomItemStack(ItemStack item, String itemName, String ... lore) {
        return HeadUtils.createCustomItemStack(item, itemName, List.of(lore));
    }

    public static void setLore(ItemStack itemStack, List<String> lore) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static void setLore(ItemStack itemStack, String ... loreLines) {
        List<String> lore = List.of(loreLines);
        HeadUtils.setLore(itemStack, lore);
    }

    public static void addLore(ItemStack itemStack, String ... loreLines) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            ArrayList<String> lore = itemMeta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.addAll(List.of(loreLines));
            itemMeta.setLore(lore);
        }
        itemStack.setItemMeta(itemMeta);
    }
}

