/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.gameplay;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.gui.service.requirements.model.ItemScope;

public class InventoryUtil {
    private InventoryUtil() {
    }

    public static boolean playerEnoughItem(Player player, ItemScope itemScope, int amount) {
        return InventoryUtil.getItemsNumberInInventory(player, itemScope) >= amount;
    }

    public static int getItemsNumberInInventory(Player player, ItemScope itemScope) {
        if (player == null || itemScope == null) {
            return 0;
        }
        int total = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0 || !itemScope.isInScope(item)) continue;
            total += item.getAmount();
        }
        return total;
    }

    public static void removeItemsFromInventory(Player player, ItemScope itemScope, int amountToRemove) {
        if (player == null || itemScope == null || amountToRemove <= 0) {
            return;
        }
        int amountRemoved = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0 || !itemScope.isInScope(item)) continue;
            int itemAmount = item.getAmount();
            int remainingToRemove = amountToRemove - amountRemoved;
            int toRemove = Math.min(itemAmount, remainingToRemove);
            item.setAmount(itemAmount - toRemove);
            if ((amountRemoved += toRemove) >= amountToRemove) break;
        }
    }
}

