/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.gameplay;

import java.util.Iterator;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.storage.impl.FortDataStorage;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.war.fort.Fort;

public class TANCustomNBT {
    private TANCustomNBT() {
        throw new IllegalStateException("Utility class");
    }

    public static void addCustomStringTag(@NotNull ItemStack item, @NotNull String tagName, @NotNull String tagValue) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)TownsAndNations.getPlugin(), tagName), PersistentDataType.STRING, (Object)tagValue);
            item.setItemMeta(meta);
        }
    }

    @Nullable
    public static String getCustomStringTag(@NotNull ItemStack item, @NotNull String tagName) {
        if (item.getItemMeta() == null) {
            return null;
        }
        if (item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)TownsAndNations.getPlugin(), tagName), PersistentDataType.STRING)) {
            return (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)TownsAndNations.getPlugin(), tagName), PersistentDataType.STRING);
        }
        return null;
    }

    public static void setBockMetaData(@NotNull Block block, @NotNull String metaData, @NotNull String value) {
        block.setMetadata(metaData, (MetadataValue)new FixedMetadataValue((Plugin)TownsAndNations.getPlugin(), (Object)value));
    }

    public static void removeBockMetaData(@NotNull Block block, @NotNull String metaData) {
        block.removeMetadata(metaData, (Plugin)TownsAndNations.getPlugin());
    }

    @Nullable
    public static String getBockMetaData(Block block, String metaData) {
        if (!block.hasMetadata(metaData)) {
            return null;
        }
        return ((MetadataValue)block.getMetadata(metaData).get(0)).asString();
    }

    public static void setBlocsData() {
        TANCustomNBT.setSignData();
        TANCustomNBT.setLandmarksData();
        TANCustomNBT.setFortData();
    }

    private static void setFortData() {
        for (Fort fort : FortDataStorage.getInstance().getForts()) {
            fort.setProtectedBlockData();
        }
    }

    public static void setSignData() {
        for (TownData townData : TownDataStorage.getInstance().getAll().values()) {
            Iterator<PropertyData> iterator = townData.getPropertyDataMap().values().iterator();
            while (iterator.hasNext()) {
                PropertyData propertyData = iterator.next();
                Optional<Block> optBlock = propertyData.getSign();
                if (optBlock.isPresent()) {
                    Block block = optBlock.get();
                    Location blockBeneathLocation = block.getLocation().add(0.0, -1.0, 0.0);
                    Block blockBeneath = blockBeneathLocation.getWorld().getBlockAt(blockBeneathLocation);
                    TANCustomNBT.setBockMetaData(block, "propertySign", propertyData.getTotalID());
                    TANCustomNBT.setBockMetaData(blockBeneath, "propertySign", propertyData.getTotalID());
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public static void setLandmarksData() {
        for (Landmark landmark : LandmarkStorage.getInstance().getAll().values()) {
            landmark.getChest().ifPresent(block -> TANCustomNBT.setBockMetaData(block, "LandmarkChest", landmark.getID()));
        }
    }
}

