/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.territory;

import java.util.Optional;
import java.util.Set;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.storage.stored.FortStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.war.fort.Fort;

public class ChunkPolygon {
    private final TerritoryData territoryOwner;
    private final Set<ClaimedChunk2> chunksInPolygon;

    public ChunkPolygon(TerritoryData territoryData, Set<ClaimedChunk2> chunksInPolygon) {
        this.territoryOwner = territoryData;
        this.chunksInPolygon = chunksInPolygon;
    }

    public Set<ClaimedChunk2> getChunksInPolygon() {
        return this.chunksInPolygon;
    }

    public boolean isSupplied() {
        Optional<Object> capitalChunk = Optional.empty();
        TerritoryData territoryData = this.territoryOwner;
        if (territoryData instanceof TownData) {
            TownData townData = (TownData)territoryData;
            capitalChunk = townData.getCapitalLocation();
        }
        for (ClaimedChunk2 claimedChunk2 : this.chunksInPolygon) {
            for (Fort fort : FortStorage.getInstance().getOwnedFort(this.territoryOwner)) {
                if (!claimedChunk2.containsPosition(fort.getPosition())) continue;
                return true;
            }
            if (!capitalChunk.isPresent() || !claimedChunk2.getVector2D().equals(capitalChunk.get())) continue;
            return true;
        }
        return false;
    }

    public void unclaimAll() {
        for (ClaimedChunk2 claimedChunk2 : this.chunksInPolygon) {
            NewClaimedChunkStorage.getInstance().unclaimChunk(claimedChunk2);
        }
    }

    public boolean contains(ClaimedChunk2 claimedChunk) {
        for (ClaimedChunk2 chunkInPolygon : this.chunksInPolygon) {
            if (!claimedChunk.equals(chunkInPolygon)) continue;
            return true;
        }
        return false;
    }
}

