/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.legacy.wargoals;

import java.util.ArrayList;
import org.bukkit.Material;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class ConquerWarGoal
extends WarGoal {
    private final int numberOfChunks;

    public ConquerWarGoal(int nbChunks) {
        this.numberOfChunks = nbChunks;
    }

    @Override
    public IconBuilder getIcon(LangType langType) {
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        description.add(Lang.CONQUER_WAR_GOAL_DESC.get());
        description.add(Lang.CONQUER_WAR_GOAL_DESC1.get(Integer.toString(this.numberOfChunks)));
        return this.buildIcon(Material.IRON_SWORD, description, langType);
    }

    @Override
    public String getDisplayName(LangType langType) {
        return Lang.CONQUER_WAR_GOAL.get(langType, new String[0]);
    }

    @Override
    public void applyWarGoal(TerritoryData winner, TerritoryData loser) {
        if (winner == null) {
            return;
        }
        winner.addAvailableClaims(loser.getID(), this.numberOfChunks);
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public String getCurrentDesc(LangType langType) {
        return Lang.GUI_CONQUER_CHUNK_CURRENT_DESC.get(langType, Integer.toString(this.numberOfChunks));
    }
}

