/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.legacy.wargoals;

import java.util.ArrayList;
import org.bukkit.Material;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class LiberateWarGoal
extends WarGoal {
    private final String territoryToLiberateID;

    public LiberateWarGoal(TerritoryData territoryToLiberate) {
        this.territoryToLiberateID = territoryToLiberate.getID();
    }

    @Override
    public IconBuilder getIcon(LangType langType) {
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        description.add(Lang.LIBERATE_SUBJECT_WAR_GOAL_DESC.get());
        description.add(Lang.LIBERATE_SUBJECT_WAR_GOAL_DESC1.get(this.getTerritoryToLiberate().getName()));
        return this.buildIcon(Material.LANTERN, description, langType);
    }

    @Override
    public String getDisplayName(LangType langType) {
        return Lang.LIBERATE_SUBJECT_WAR_GOAL.get(langType, new String[0]);
    }

    @Override
    public void applyWarGoal(TerritoryData winner, TerritoryData loser) {
        if (!this.getTerritoryToLiberate().haveOverlord()) {
            return;
        }
        this.getTerritoryToLiberate().removeOverlord();
    }

    @Override
    public boolean isCompleted() {
        return this.getTerritoryToLiberate() != null;
    }

    @Override
    public String getCurrentDesc(LangType langType) {
        if (this.getTerritoryToLiberate() == null) {
            return null;
        }
        return Lang.GUI_WARGOAL_LIBERATE_WAR_GOAL_RESULT.get(langType, this.getTerritoryToLiberate().getName());
    }

    public TerritoryData getTerritoryToLiberate() {
        return TerritoryUtil.getTerritory(this.territoryToLiberateID);
    }
}

