/*
 * Decompiled with CFR 0.152.
 */
package com.kerbe.saturation_plus.command;

import com.kerbe.saturation_plus.Utilities;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodData;

public class SetSaturationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"setSaturation").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).requires(source -> source.m_6761_(3))).executes(context -> SetSaturationCommand.execute((CommandContext<CommandSourceStack>)context))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float value = (float)DoubleArgumentType.getDouble(context, (String)"value");
            FoodData fd = player.m_36324_();
            float saturation = fd.m_38722_();
            fd.m_38717_(Math.max(0.0f, Math.min(value, Float.MAX_VALUE)));
            float newSaturation = Utilities.clampSaturation(player, fd.m_38722_());
            player.m_213846_(Utilities.displayComparison(saturation, newSaturation));
            player.m_213846_(Utilities.displaySaturation(player, newSaturation, false));
        }
        return 1;
    }
}

