/*
 * Decompiled with CFR 0.152.
 */
package com.kerbe.command;

import com.kerbe.Utilities;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodData;

public class AddSaturationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"addSaturation").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).requires(source -> source.hasPermission(3))).executes(context -> AddSaturationCommand.execute((CommandContext<CommandSourceStack>)context))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float value = (float)DoubleArgumentType.getDouble(context, (String)"value");
            FoodData fd = player.getFoodData();
            float saturation = fd.getSaturationLevel();
            fd.setSaturation(Math.max(0.0f, Math.min(saturation + value, Float.MAX_VALUE)));
            float newSaturation = Utilities.clampSaturation(player, fd.getSaturationLevel());
            player.sendSystemMessage(Utilities.displayComparison(saturation, newSaturation));
            player.sendSystemMessage(Utilities.displaySaturation(player, newSaturation, false));
        }
        return 1;
    }
}

