/*
 * Decompiled with CFR 0.152.
 */
package com.kerbe.saturation_plus;

import com.kerbe.saturation_plus.SaturationPlus;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class Utilities {
    public static Component displaySaturation(ServerPlayer player, float saturation, boolean clamp) {
        return Utilities.formatSaturationUpdate(clamp ? Utilities.clampSaturation(player, saturation) : saturation);
    }

    public static Component formatSaturationUpdate(float saturation) {
        float hunger_bars = (float)Math.floor(saturation / 2.0f);
        return Component.translatable((String)"message.saturation", (Object[])new Object[]{new DecimalFormat("0.00").format(saturation), new DecimalFormat("0").format(hunger_bars), Component.translatable((String)(hunger_bars == 1.0f ? "message.hungerbar.singular" : "message.hungerbar.plural"))});
    }

    public static Component displayComparison(float prev_saturation, float new_saturation) {
        return Utilities.formatSaturationDifference(new_saturation - prev_saturation);
    }

    public static Component formatSaturationDifference(float diff) {
        return Component.translatable((String)(diff == 0.0f ? "message.saturation.unchanged" : "message.saturation.changed"), (Object[])new Object[]{diff < 0.0f ? String.valueOf(diff) : "+" + diff});
    }

    public static boolean isPowerOf2(float f) {
        if (f <= 0.0f) {
            return false;
        }
        if (f % 1.0f != 0.0f) {
            return f < 1.0f && Utilities.isPowerOf2(f * 2.0f);
        }
        if (f % 2.0f == 1.0f) {
            return f == 1.0f;
        }
        return Utilities.isPowerOf2(f / 2.0f);
    }

    public static float clampSaturation(ServerPlayer player, float projected_sat) {
        float true_sat_cap;
        boolean food_limits_sat = player.serverLevel().getGameRules().getBoolean(SaturationPlus.HUNGER_LIMITS_SATURATION);
        int sat_cap = player.serverLevel().getGameRules().getInt(SaturationPlus.SATURATION_CAP);
        float f = true_sat_cap = (float)sat_cap >= 0.0f ? (float)sat_cap : Float.MAX_VALUE;
        if (food_limits_sat) {
            true_sat_cap = Math.min(true_sat_cap, (float)player.getFoodData().getFoodLevel());
        }
        return Math.max(0.0f, Math.min(projected_sat, true_sat_cap));
    }
}

