/*
 * Decompiled with CFR 0.152.
 */
package com.kerbe.saturation_plus.mixin;

import com.kerbe.saturation_plus.SaturationPlus;
import com.kerbe.saturation_plus.Utilities;
import com.kerbe.saturation_plus.mixin.FoodDataAccessor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public class PlayerHungerMixin {
    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick_plus(Player player, CallbackInfo info) {
        FoodDataAccessor accessor = (FoodDataAccessor)((Object)this);
        float saturationLevel = accessor.getSaturationLevel();
        GameRules gameRules = player.level().getGameRules();
        if (gameRules != null) {
            int sat_cap;
            boolean food_limits_sat = gameRules.getBoolean(SaturationPlus.HUNGER_LIMITS_SATURATION);
            if (food_limits_sat) {
                int foodLevel = accessor.getFoodLevel();
                saturationLevel = Math.min(saturationLevel, (float)foodLevel);
                accessor.setSaturationLevel(saturationLevel);
            }
            accessor.setSaturationLevel(Math.min(saturationLevel, (sat_cap = gameRules.getInt(SaturationPlus.SATURATION_CAP)) < 0 ? Float.MAX_VALUE : (float)sat_cap));
            saturationLevel = accessor.getSaturationLevel();
            float exhaustion = accessor.getExhaustionLevel();
            if (exhaustion > 4.0f && (double)saturationLevel >= Math.pow(2.0, 24.0)) {
                accessor.setExhaustionLevel(exhaustion - 4.0f);
                int exp = Utilities.isPowerOf2(saturationLevel) ? 24 : 23;
                accessor.setSaturationLevel(Math.max(saturationLevel - (float)((double)saturationLevel / Math.pow(2.0, exp)), 0.0f));
            }
        }
    }
}

