/*
 * Decompiled with CFR 0.152.
 */
package com.kerbe.saturation_plus;

import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;

public class Utilities {
    public static Component formatSaturationChange(float saturationChange) {
        return Component.translatable((String)Utilities.queryIfAdded(saturationChange), (Object[])new Object[]{new DecimalFormat("0.00").format(Math.abs(saturationChange))});
    }

    public static Component formatSaturationUpdate(String headerKey, float saturation) {
        return Component.translatable((String)"message.saturation_format", (Object[])new Object[]{Utilities.formatSaturation(headerKey, saturation), Utilities.formatHungerBars(saturation)});
    }

    private static Component formatSaturation(String key, float saturation) {
        return Component.translatable((String)key, (Object[])new Object[]{new DecimalFormat("0.00").format(saturation)});
    }

    private static Component formatHungerBars(float saturation) {
        int sat_bars = (int)(saturation / 2.0f);
        return Component.translatable((String)(sat_bars == 1 ? "message.saturation_hunger_bar" : "message.saturation_hunger_bars"), (Object[])new Object[]{sat_bars});
    }

    public static String queryIfAdded(float saturationChange) {
        return saturationChange < 0.0f ? "message.saturation_decrease" : "message.saturation_increase";
    }

    public static String queryIfChanged(float saturation, float newSaturation, String defaultHeaderKey) {
        return saturation == newSaturation ? "message.saturation_unchanged" : defaultHeaderKey;
    }
}

