/*
 * Decompiled with CFR 0.152.
 */
package com.kerbe.saturation_plus.command;

import com.kerbe.saturation_plus.Utilities;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodData;

public class SetSaturationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"setSaturation").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).requires(source -> source.hasPermission(3))).executes(context -> SetSaturationCommand.execute((CommandContext<CommandSourceStack>)context))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float value = (float)DoubleArgumentType.getDouble(context, (String)"value");
            FoodData fd = player.getFoodData();
            float saturation = fd.getSaturationLevel();
            fd.setSaturation(Math.max(0.0f, value));
            float newSaturation = fd.getSaturationLevel();
            player.sendSystemMessage(Utilities.formatSaturationUpdate(Utilities.queryIfChanged(saturation, newSaturation, "message.saturation_set"), newSaturation));
        }
        return 1;
    }
}

