/*
 * Decompiled with CFR 0.152.
 */
package com.saolghra.armor_hud.client;

import com.saolghra.armor_hud.client.config.ArmorHudConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ArmorHudOverlay {
    private final ArmorHudConfig config = ArmorHudConfig.getInstance();
    private static final class_2960 HOTBAR_TEXTURE = class_2960.method_60655((String)"armor_hud", (String)"textures/gui/hotbar_texture.png");
    private static final class_2960 EXCLAMATION_MARKS_TEXTURE = class_2960.method_60655((String)"armor_hud", (String)"textures/gui/exclamation_marks_flash.png");

    public void renderArmorUI(class_332 context) {
        int armorSpacing;
        class_1799 armorItem;
        int i;
        class_310 client = class_310.method_1551();
        if (!this.config.isVisible() || client.field_1690.field_1842 || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_1799[] armorItems = new class_1799[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            armorItems[i2] = client.field_1724.method_31548().method_5438(36 + i2);
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int boxSize = this.config.getBoxSize();
        int spacing = this.config.getSpacing();
        int xOffset = screenWidth / 2 + this.config.getXOffset();
        int yOffset = screenHeight + this.config.getYOffset();
        for (i = armorItems.length - 1; i >= 0; --i) {
            armorItem = armorItems[i];
            if (armorItem.method_7960()) continue;
            armorSpacing = (armorItems.length - 1 - i) * (boxSize + spacing);
            this.drawTexture(context, xOffset + armorSpacing, yOffset, boxSize, boxSize);
            context.method_51427(armorItem, xOffset + armorSpacing + (boxSize - 16) / 2, yOffset + (boxSize - 16) / 2);
        }
        for (i = armorItems.length - 1; i >= 0; --i) {
            armorItem = armorItems[i];
            if (armorItem.method_7960()) continue;
            armorSpacing = (armorItems.length - 1 - i) * (boxSize + spacing);
            this.drawDurabilityBar(context, xOffset + armorSpacing, yOffset + boxSize - 6, boxSize, armorItem);
            if (!this.isDurabilityLow(armorItem) || !this.config.isShowExclamationMarks()) continue;
            this.drawExclamationMark(context, xOffset + armorSpacing, yOffset, boxSize);
        }
    }

    private boolean isDurabilityLow(class_1799 item) {
        int maxDamage = item.method_7936();
        int damage = item.method_7919();
        return damage > 0 && (float)(maxDamage - damage) / (float)maxDamage < this.config.getDurabilityWarningThreshold();
    }

    private void drawExclamationMark(class_332 context, int boxX, int boxY, int boxSize) {
        long currentTime = System.currentTimeMillis();
        float bobbingOffset = (float)Math.sin((double)currentTime / 200.0) * 2.0f;
        int iconSize = 11;
        int offsetX = -1;
        int offsetY = -2;
        int drawX = boxX + offsetX;
        int drawY = boxY + offsetY + (int)bobbingOffset;
        context.method_25290(class_10799.field_56883, EXCLAMATION_MARKS_TEXTURE, drawX, drawY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    private void drawTexture(class_332 context, int x, int y, int width, int height) {
        context.method_25290(class_10799.field_56883, HOTBAR_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    private void drawDurabilityBar(class_332 context, int x, int y, int width, class_1799 item) {
        int maxDamage = item.method_7936();
        int damage = item.method_7919();
        if (damage == 0) {
            return;
        }
        int barWidth = 13;
        int barX = x + (width - barWidth) / 2 + 1;
        int barHeight = 2;
        float durabilityRatio = (float)(maxDamage - damage) / (float)maxDamage;
        int remainingWidth = Math.round(durabilityRatio * 13.0f);
        int barColor = this.convertHSVtoARGB(durabilityRatio / 3.0f * 360.0f, 1.0f, 1.0f);
        this.fill(context, barX, y, barX + barWidth, y + barHeight, -16777216);
        this.fill(context, barX, y, barX + remainingWidth, y + barHeight / 2, barColor);
    }

    private void fill(class_332 context, int x1, int y1, int x2, int y2, int color) {
        context.method_25294(x1, y1, x2, y2, color);
    }

    private int convertHSVtoARGB(float h, float s, float v) {
        h = (h % 360.0f + 360.0f) % 360.0f;
        float hh = h / 60.0f;
        int i = (int)hh % 6;
        float f = hh - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        int r = 0;
        int g = 0;
        int b = 0;
        switch (i) {
            case 0: {
                r = Math.round(v * 255.0f);
                g = Math.round(t * 255.0f);
                b = Math.round(p * 255.0f);
                break;
            }
            case 1: {
                r = Math.round(q * 255.0f);
                g = Math.round(v * 255.0f);
                b = Math.round(p * 255.0f);
                break;
            }
            case 2: {
                r = Math.round(p * 255.0f);
                g = Math.round(v * 255.0f);
                b = Math.round(t * 255.0f);
                break;
            }
            case 3: {
                r = Math.round(p * 255.0f);
                g = Math.round(q * 255.0f);
                b = Math.round(v * 255.0f);
                break;
            }
            case 4: {
                r = Math.round(t * 255.0f);
                g = Math.round(p * 255.0f);
                b = Math.round(v * 255.0f);
                break;
            }
            case 5: {
                r = Math.round(v * 255.0f);
                g = Math.round(p * 255.0f);
                b = Math.round(q * 255.0f);
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

