/*
 * Decompiled with CFR 0.152.
 */
package com.saolghra.armor_hud.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ArmorHudConfig {
    private static volatile ArmorHudConfig INSTANCE;
    private static final Gson GSON;
    private static final Path CONFIG_PATH;
    private int xOffset;
    private int yOffset;
    private boolean showExclamationMarks;
    private float durabilityWarningThreshold;
    private int boxSize;
    private int spacing;
    private boolean visible;
    private static final int DEFAULT_X_OFFSET = -224;
    private static final int DEFAULT_Y_OFFSET = -22;
    private static final int DEFAULT_BOX_SIZE = 22;
    private static final int DEFAULT_SPACING = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArmorHudConfig getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ArmorHudConfig> clazz = ArmorHudConfig.class;
        synchronized (ArmorHudConfig.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = ArmorHudConfig.loadOrCreate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static ArmorHudConfig loadOrCreate() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (ArmorHudConfig)GSON.fromJson(json, ArmorHudConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        }
        return ArmorHudConfig.createDefaultConfig();
    }

    private static ArmorHudConfig createDefaultConfig() {
        ArmorHudConfig config = new ArmorHudConfig();
        config.xOffset = -224;
        config.yOffset = -22;
        config.boxSize = 22;
        config.spacing = 2;
        config.showExclamationMarks = true;
        config.durabilityWarningThreshold = 0.2f;
        config.visible = true;
        config.saveConfig();
        return config;
    }

    private void initDefaults() {
        this.xOffset = -224;
        this.yOffset = -22;
        this.boxSize = 22;
        this.spacing = 2;
        this.showExclamationMarks = true;
        this.durabilityWarningThreshold = 0.2f;
        this.visible = true;
    }

    private void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                ArmorHudConfig loaded = (ArmorHudConfig)GSON.fromJson(json, ArmorHudConfig.class);
                if (loaded != null) {
                    this.copyFrom(loaded);
                }
            } else {
                this.saveConfig();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load config: " + e.getMessage());
        }
    }

    public void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    private void copyFrom(ArmorHudConfig other) {
        if (other != null) {
            this.xOffset = other.xOffset;
            this.yOffset = other.yOffset;
            this.showExclamationMarks = other.showExclamationMarks;
            this.durabilityWarningThreshold = other.durabilityWarningThreshold;
            this.boxSize = other.boxSize;
            this.spacing = other.spacing;
            this.visible = other.visible;
        }
    }

    public void resetToDefaults() {
        ArmorHudConfig defaults = ArmorHudConfig.createDefaultConfig();
        this.copyFrom(defaults);
        this.saveConfig();
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
        this.saveConfig();
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
        this.saveConfig();
    }

    public boolean isShowExclamationMarks() {
        return this.showExclamationMarks;
    }

    public void setShowExclamationMarks(boolean show) {
        this.showExclamationMarks = show;
        this.saveConfig();
    }

    public float getDurabilityWarningThreshold() {
        return this.durabilityWarningThreshold;
    }

    public void setDurabilityWarningThreshold(float threshold) {
        this.durabilityWarningThreshold = threshold;
        this.saveConfig();
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(int size) {
        this.boxSize = size;
        this.saveConfig();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.saveConfig();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.saveConfig();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("armor_hud.json");
    }
}

