/*
 * Decompiled with CFR 0.152.
 */
package com.saolghra.armor_hud.client.config;

import com.saolghra.armor_hud.client.config.ArmorHudConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
class SimpleConfigScreen
extends class_437 {
    private final class_437 parent;
    private final ArmorHudConfig config;
    private boolean isDragging = false;
    private boolean isInteractiveMode = false;
    private int initialConfigX = 0;
    private int initialConfigY = 0;
    private double dragDeltaX = 0.0;
    private double dragDeltaY = 0.0;
    private final class_1799[] previewArmor = new class_1799[]{new class_1799((class_1935)class_1802.field_8805), new class_1799((class_1935)class_1802.field_8058), new class_1799((class_1935)class_1802.field_8348), new class_1799((class_1935)class_1802.field_8285)};

    protected SimpleConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Armor HUD Configuration"));
        this.parent = parent;
        this.config = ArmorHudConfig.getInstance();
        for (class_1799 armor : this.previewArmor) {
            if (armor.method_7936() <= 0) continue;
            armor.method_7974((int)((double)armor.method_7936() * 0.7));
        }
    }

    protected void method_25426() {
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.field_22789 / 2 - buttonWidth / 2;
        int currentY = 45;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("HUD Visible: " + this.config.isVisible())), button -> {
            this.config.setVisible(!this.config.isVisible());
            button.method_25355((class_2561)class_2561.method_43470((String)("HUD Visible: " + this.config.isVisible())));
        }).method_46434(centerX, currentY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.isInteractiveMode ? "Exit Interactive Mode" : "Interactive Positioning")), button -> {
            this.isInteractiveMode = !this.isInteractiveMode;
            this.isDragging = false;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.isInteractiveMode ? "Exit Interactive Mode" : "Interactive Positioning")));
        }).method_46434(centerX, currentY += 30, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Show Exclamation Marks: " + this.config.isShowExclamationMarks())), button -> {
            this.config.setShowExclamationMarks(!this.config.isShowExclamationMarks());
            button.method_25355((class_2561)class_2561.method_43470((String)("Show Exclamation Marks: " + this.config.isShowExclamationMarks())));
        }).method_46434(centerX, currentY += 35, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset to Defaults"), button -> this.config.resetToDefaults()).method_46434(centerX, currentY += 30, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }).method_46434(centerX, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431());
    }

    public boolean method_25402(class_11909 click, boolean isDoubleClick) {
        if (this.isInteractiveMode && click.method_74245() == 0) {
            int hudX = this.getHudX();
            int hudY = this.getHudY();
            int totalWidth = this.getTotalHudWidth();
            int hudHeight = this.config.getBoxSize();
            if (click.comp_4798() >= (double)hudX && click.comp_4798() <= (double)(hudX + totalWidth) && click.comp_4799() >= (double)hudY && click.comp_4799() <= (double)(hudY + hudHeight)) {
                this.isDragging = true;
                this.initialConfigX = this.config.getXOffset();
                this.initialConfigY = this.config.getYOffset();
                this.dragDeltaX = 0.0;
                this.dragDeltaY = 0.0;
                return true;
            }
        }
        return super.method_25402(click, isDoubleClick);
    }

    public boolean method_25406(class_11909 click) {
        if (this.isDragging && click.method_74245() == 0) {
            this.isDragging = false;
            return true;
        }
        return super.method_25406(click);
    }

    public boolean method_25403(class_11909 click, double deltaX, double deltaY) {
        if (this.isDragging && this.isInteractiveMode) {
            this.dragDeltaX += deltaX;
            this.dragDeltaY += deltaY;
            this.config.setXOffset(this.initialConfigX + (int)this.dragDeltaX);
            this.config.setYOffset(this.initialConfigY + (int)this.dragDeltaY);
            return true;
        }
        return super.method_25403(click, deltaX, deltaY);
    }

    private int getHudX() {
        return this.field_22789 / 2 + this.config.getXOffset();
    }

    private int getHudY() {
        return this.field_22790 + this.config.getYOffset();
    }

    private int getTotalHudWidth() {
        return 4 * this.config.getBoxSize() + 3 * this.config.getSpacing();
    }

    private void renderPreviewHud(class_332 context) {
        int armorSpacing;
        class_1799 armorItem;
        int i;
        if (!this.isInteractiveMode) {
            return;
        }
        int boxSize = this.config.getBoxSize();
        int spacing = this.config.getSpacing();
        int xOffset = this.getHudX();
        int yOffset = this.getHudY();
        for (i = this.previewArmor.length - 1; i >= 0; --i) {
            armorItem = this.previewArmor[i];
            armorSpacing = (this.previewArmor.length - 1 - i) * (boxSize + spacing);
            context.method_25294(xOffset + armorSpacing, yOffset, xOffset + armorSpacing + boxSize, yOffset + boxSize, Integer.MIN_VALUE);
            context.method_51427(armorItem, xOffset + armorSpacing + (boxSize - 16) / 2, yOffset + (boxSize - 16) / 2);
        }
        for (i = this.previewArmor.length - 1; i >= 0; --i) {
            float durabilityRatio;
            int maxDamage;
            int damage;
            armorItem = this.previewArmor[i];
            armorSpacing = (this.previewArmor.length - 1 - i) * (boxSize + spacing);
            if (armorItem.method_7936() > 0) {
                damage = armorItem.method_7919();
                maxDamage = armorItem.method_7936();
                durabilityRatio = (float)(maxDamage - damage) / (float)maxDamage;
                int barWidth = 13;
                int barX = xOffset + armorSpacing + (boxSize - barWidth) / 2 + 1;
                int barY = yOffset + boxSize - 6;
                int barHeight = 2;
                int remainingWidth = Math.round(durabilityRatio * 13.0f);
                int barColor = durabilityRatio > 0.5f ? -16711936 : -65536;
                context.method_25294(barX, barY, barX + barWidth, barY + barHeight, -16777216);
                context.method_25294(barX, barY, barX + remainingWidth, barY + barHeight, barColor);
            }
            if (!this.config.isShowExclamationMarks() || armorItem.method_7936() <= 0) continue;
            damage = armorItem.method_7919();
            maxDamage = armorItem.method_7936();
            durabilityRatio = (float)(maxDamage - damage) / (float)maxDamage;
            if (!(durabilityRatio < this.config.getDurabilityWarningThreshold())) continue;
            context.method_25303(this.field_22793, "!", xOffset + armorSpacing - 1, yOffset - 2, -256);
        }
        if (this.isDragging) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Dragging..."), this.field_22789 / 2, 20, 0xFFFFFF);
        } else {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Click and drag the armor HUD to position it"), this.field_22789 / 2, 20, 0xFFFFFF);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int blurAlpha = this.isInteractiveMode ? 0x20000000 : 0x40000000;
        context.method_25294(0, 0, this.field_22789, this.field_22790, blurAlpha);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderPreviewHud(context);
    }
}

