package fr.kolala.slimemap.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multisets;
import fr.kolala.slimemap.config.ConfigHelper;
import org.jetbrains.annotations.Nullable;

import java.util.Random;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import net.minecraft.class_5321;

public class FilledSlimeMapItem extends class_1806 {

    public FilledSlimeMapItem(class_1793 settings) {
        super(settings);
    }

    private static final String MAP_KEY = "map";

    public static class_1799 method_8005(class_1937 world, int x, int z, byte scale, boolean showIcons, boolean unlimitedTracking) {
        class_1799 itemStack = new class_1799(ModItems.FILLED_SLIME_MAP);
        FilledSlimeMapItem.method_8000(itemStack, world, x, z, scale, showIcons, unlimitedTracking, world.method_27983());
        return itemStack;
    }

    @Nullable
    public static class_22 method_7997(@Nullable Integer id, class_1937 world) {
        return id == null ? null : world.method_17891(FilledSlimeMapItem.method_17440(id));
    }

    @Nullable
    public static class_22 method_8001(class_1799 map, class_1937 world) {
        Integer integer = FilledSlimeMapItem.method_8003(map);
        return FilledSlimeMapItem.method_7997(integer, world);
    }

    @Nullable
    public static Integer method_8003(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound != null && nbtCompound.method_10573(MAP_KEY, class_2520.field_33263) ? nbtCompound.method_10550(MAP_KEY) : null;
    }

    private static int method_32349(class_1937 world, int x, int z, int scale, boolean showIcons, boolean unlimitedTracking, class_5321<class_1937> dimension) {
        class_22 mapState = class_22.method_32363(x, z, (byte)scale, showIcons, unlimitedTracking, dimension);
        int i = world.method_17889();
        world.method_17890(FilledSlimeMapItem.method_17440(i), mapState);
        return i;
    }

    private static void method_32348(class_1799 stack, int id) {
        stack.method_7948().method_10569(MAP_KEY, id);
    }

    private static void method_8000(class_1799 stack, class_1937 world, int x, int z, int scale, boolean showIcons, boolean unlimitedTracking, class_5321<class_1937> dimension) {
        int i = FilledSlimeMapItem.method_32349(world, x, z, scale, showIcons, unlimitedTracking, dimension);
        FilledSlimeMapItem.method_32348(stack, i);
    }

    public static String method_17440(int mapId) {
        return "map_" + mapId;
    }

    private boolean isSlimeChunk(long seed, int xPos, int zPos) {
        Random random = new Random(seed +
                ((long) xPos * xPos * 0x4c1906) +
                (xPos * 0x5ac0dbL) +
                ((long) zPos * zPos) * 0x4307a7L +
                (zPos * 0x5f24fL) ^ 0x3ad8025fL);
        return random.nextInt(10) == 0;
    }

    @Override
    public void method_7998(class_1937 world, class_1297 entity, class_22 state) {
        if (world.method_27983() != class_1937.field_25179 || !(entity instanceof class_1657) || world.method_8503() == null) {
            return;
        }
        long seed = world.method_8503().method_27728().method_28057().method_28028();
        int i = 1 << state.field_119;
        int j = state.field_116;
        int k = state.field_115;
        int l = class_3532.method_15357(entity.method_23317() - (double)j) / i + 64;
        int m = class_3532.method_15357(entity.method_23321() - (double)k) / i + 64;
        int n = 128 / i;
        class_22.class_23 playerUpdateTracker = state.method_101((class_1657)entity);
        ++playerUpdateTracker.field_131;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338.class_2339 mutable2 = new class_2338.class_2339();
        boolean bl = false;
        for (int o = l - n + 1; o < l + n; ++o) {
            if ((o & 0xF) != (playerUpdateTracker.field_131 & 0xF) && !bl) continue;
            bl = false;
            double d = 0.0;
            for (int p = m - n - 1; p < m + n; ++p) {
                double f;
                if (o < 0 || p < -1 || o >= 128 || p >= 128) continue;
                int q = class_3532.method_34954(o - l) + class_3532.method_34954(p - m);
                boolean bl2 = q > (n - 2) * (n - 2);
                int r = (j / i + o - 64) * i;
                int s = (k / i + p - 64) * i;
                LinkedHashMultiset<class_3620> multiset = LinkedHashMultiset.create();
                class_2818 worldChunk = world.method_8497(class_4076.method_18675(r), class_4076.method_18675(s));
                if (worldChunk.method_12223()) continue;
                int t = 0;
                double e = 0.0;
                for (int u = 0; u < i; ++u) {
                    for (int v = 0; v < i; ++v) {
                        class_2680 blockState;
                        mutable.method_10103(r + u, 0, s + v);
                        int w = worldChunk.method_12005(class_2902.class_2903.field_13202, mutable.method_10263(), mutable.method_10260()) + 1;
                        if (isSlimeChunk(seed, worldChunk.method_12004().field_9181, worldChunk.method_12004().field_9180)) {
                            if (ConfigHelper.getInt("coverBlocks") == 1) {
                                multiset.add(class_2246.field_10030.method_26403(), Integer.MAX_VALUE);
                                continue;
                            } else {
                                blockState = class_2246.field_10030.method_9564();
                            }
                        }
                        else if (w > world.method_31607() + 1) {
                            do {
                                mutable.method_33098(--w);
                            } while ((blockState = worldChunk.method_8320(mutable)).method_26205(world, mutable) == class_3620.field_16008 && w > world.method_31607());
                            if (w > world.method_31607() && !blockState.method_26227().method_15769()) {
                                class_2680 blockState2;
                                int x = w - 1;
                                mutable2.method_10101(mutable);
                                do {
                                    mutable2.method_33098(x--);
                                    blockState2 = worldChunk.method_8320(mutable2);
                                    ++t;
                                } while (x > world.method_31607() && !blockState2.method_26227().method_15769());
                                blockState = this.method_7995(world, blockState, mutable);
                            }
                        } else {
                            blockState = class_2246.field_9987.method_9564();
                        }
                        state.method_109(world, mutable.method_10263(), mutable.method_10260());
                        e += (double)w / (double)(i * i);
                        multiset.add(blockState.method_26205(world, mutable));
                    }
                }
                class_3620 mapColor = Iterables.getFirst(Multisets.copyHighestCountFirst(multiset), class_3620.field_16008);
                class_3620.class_6594 brightness = mapColor == class_3620.field_16019 ? ((f = (double) (t / (i * i)) * 0.1 + (double)(o + p & 1) * 0.2) < 0.5 ? class_3620.class_6594.field_34761 : (f > 0.9 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760)) : ((f = (e - d) * 4.0 / (double)(i + 4) + ((double)(o + p & 1) - 0.5) * 0.4) > 0.6 ? class_3620.class_6594.field_34761 : (f < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760));
                d = e;
                if (p < 0 || q >= n * n || bl2 && (o + p & 1) == 0) continue;
                bl |= state.method_32365(o, p, mapColor.method_38481(brightness));
            }
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236) {
            return;
        }
        class_22 mapState = FilledSlimeMapItem.method_8001(stack, world);
        if (mapState == null) {
            return;
        }
        if (entity instanceof class_1657 playerEntity) {
            mapState.method_102(playerEntity, stack);
        }
        if (!mapState.field_17403 && (selected || entity instanceof class_1657 && ((class_1657)entity).method_6079() == stack)) {
            this.method_7998(world, entity, mapState);
        }
    }

    private class_2680 method_7995(class_1937 world, class_2680 state, class_2338 pos) {
        class_3610 fluidState = state.method_26227();
        if (!fluidState.method_15769() && !state.method_26206(world, pos, class_2350.field_11036)) {
            return fluidState.method_15759();
        }
        return state;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        if (blockState.method_26164(class_3481.field_15501)) {
            class_22 mapState;
            if (!context.method_8045().field_9236 && (mapState = FilledSlimeMapItem.method_8001(context.method_8041(), context.method_8045())) != null && !mapState.method_108(context.method_8045(), context.method_8037())) {
                return class_1269.field_5814;
            }
            return class_1269.method_29236(context.method_8045().field_9236);
        }
        return super.method_7884(context);
    }
}