package fr.kolala.slimemap.mixin;

import fr.kolala.slimemap.item.FilledSlimeMapItem;
import fr.kolala.slimemap.item.ModItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3910;
import net.minecraft.class_3934;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;

@Environment(value = EnvType.CLIENT)
@Mixin(class_3934.class)
public abstract class CartographyTableScreenMixin extends class_465<class_3910> {
    @Unique
    private static final class_2960 SCALED_SLIME_MAP_TEXTURE = new class_2960("slimemap", "container/cartography_table/scaled_slime_map");
    @Unique
    private static final class_2960 DUPLICATED_SLIME_MAP_TEXTURE = new class_2960("slimemap", "container/cartography_table/duplicated_slime_map");
    @Unique
    private static final class_2960 SLIME_MAP_TEXTURE = new class_2960("slimemap", "container/cartography_table/slime_map");

    @Shadow @Final private static class_2960 ERROR_TEXTURE;
    @Shadow @Final private static class_2960 LOCKED_TEXTURE;
    @Shadow @Final private static class_2960 TEXTURE;

    @Shadow protected abstract void drawMap(class_332 context, @Nullable Integer mapId, @Nullable class_22 mapState, boolean cloneMode, boolean expandMode, boolean lockMode, boolean cannotExpand);
    @Shadow protected abstract void drawMap(class_332 context, @Nullable Integer mapId, @Nullable class_22 mapState, int x, int y, float scale);


    public CartographyTableScreenMixin(class_3910 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    /**
     * @author Kolala
     * @reason Drawing for slime map as well
     */
    @Overwrite
    public void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        class_22 mapState = null;
        Integer integer = null;
        int i = this.field_2776;
        int j = this.field_2800;
        context.method_25302(TEXTURE, i, j, 0, 0, this.field_2792, this.field_2779);
        class_1799 itemStack = this.field_2797.method_7611(1).method_7677();
        boolean bl = itemStack.method_31574(class_1802.field_8895) || itemStack.method_31574(ModItems.SLIME_MAP);
        boolean bl2 = itemStack.method_31574(class_1802.field_8407) || itemStack.method_31574(class_1802.field_8777);
        boolean bl3 = itemStack.method_31574(class_1802.field_8141);
        class_1799 itemStack2 = this.field_2797.method_7611(0).method_7677();
        boolean bl4 = false;
        boolean isSlimeMap = false;
        if (itemStack2.method_31574(class_1802.field_8204)) {
            integer = class_1806.method_8003(itemStack2);
            assert this.field_22787 != null;
            mapState = class_1806.method_7997(integer, this.field_22787.field_1687);
        } else if (itemStack2.method_31574(ModItems.FILLED_SLIME_MAP)) {
            integer = FilledSlimeMapItem.method_8003(itemStack2);
            assert this.field_22787 != null;
            mapState = FilledSlimeMapItem.method_7997(integer, this.field_22787.field_1687);
            isSlimeMap = true;
        }

        if (mapState != null) {
            if (mapState.field_17403) {
                bl4 = true;
                if (bl2 || bl3) {
                    context.method_52706(ERROR_TEXTURE, i + 35, j + 31, 28, 21);
                }
            }
            if (bl2 && mapState.field_119 >= 4) {
                bl4 = true;
                context.method_52706(ERROR_TEXTURE, i + 35, j + 31, 28, 21);
            }
        }
        if (isSlimeMap)
            this.drawSlimeMap(context, integer, mapState, bl, bl2, bl3, bl4);
        else
            this.drawMap(context, integer, mapState, bl, bl2, bl3, bl4);
    }

    @Unique
    private void drawSlimeMap(class_332 context, @Nullable Integer mapId, @Nullable class_22 mapState, boolean cloneMode, boolean expandMode, boolean lockMode, boolean cannotExpand) {
        int i = this.field_2776;
        int j = this.field_2800;
        if (expandMode && !cannotExpand) {
            context.method_52706(SCALED_SLIME_MAP_TEXTURE, i + 67, j + 13, 66, 66);
            this.drawMap(context, mapId, mapState, i + 85, j + 31, 0.226f);
        } else if (cloneMode) {
            context.method_52706(DUPLICATED_SLIME_MAP_TEXTURE, i + 67 + 16, j + 13, 50, 66);
            this.drawMap(context, mapId, mapState, i + 86, j + 16, 0.34f);
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 1.0f);
            context.method_52706(DUPLICATED_SLIME_MAP_TEXTURE, i + 67, j + 13 + 16, 50, 66);
            this.drawMap(context, mapId, mapState, i + 70, j + 32, 0.34f);
            context.method_51448().method_22909();
        } else if (lockMode) {
            context.method_52706(SLIME_MAP_TEXTURE, i + 67, j + 13, 66, 66);
            this.drawMap(context, mapId, mapState, i + 71, j + 17, 0.45f);
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 1.0f);
            context.method_52706(LOCKED_TEXTURE, i + 118, j + 60, 10, 14);
            context.method_51448().method_22909();
        } else {
            context.method_52706(SLIME_MAP_TEXTURE, i + 67, j + 13, 66, 66);
            this.drawMap(context, mapId, mapState, i + 71, j + 17, 0.45f);
        }
    }
}