package fr.kolala.slimemap.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import fr.kolala.slimemap.item.FilledSlimeMapItem;
import fr.kolala.slimemap.item.ModItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value = EnvType.CLIENT)
@Mixin(class_759.class)
public abstract class HeldItemRendererMixin {
    // TODO: Make custom texture for both of them with slime around the map
    @Unique
    private static final class_1921 SLIME_MAP_BACKGROUND = class_1921.method_23028(new class_2960("slimemap", "textures/map/slime_map_background.png"));
    @Unique
    private static final class_1921 SLIME_MAP_BACKGROUND_CHECKERBOARD = class_1921.method_23028(new class_2960("slimemap", "textures/map/slime_map_background_checkerboard.png"));

    @Shadow private class_1799 offHand;

    @Shadow protected abstract float getMapAngle(float tickDelta);

    @Shadow @Final private class_310 client;

    @Shadow protected abstract void renderArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_1306 arm);

    @Shadow private class_1799 mainHand;

    @Shadow protected abstract void renderArmHoldingItem(class_4587 matrices, class_4597 vertexConsumers, int light, float equipProgress, float swingProgress, class_1306 arm);

    @Unique
    private void renderSlimeMapInOneHand(class_4587 matrices, class_4597 vertexConsumers, int light, float equipProgress, class_1306 arm, float swingProgress, class_1799 stack) {
        float f = arm == class_1306.field_6183 ? 1.0f : -1.0f;
        matrices.method_46416(f * 0.125f, -0.125f, 0.0f);
        assert this.client.field_1724 != null;
        if (!this.client.field_1724.method_5767()) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40718.rotationDegrees(f * 10.0f));
            this.renderArmHoldingItem(matrices, vertexConsumers, light, equipProgress, swingProgress, arm);
            matrices.method_22909();
        }
        matrices.method_22903();
        matrices.method_46416(f * 0.51f, -0.08f + equipProgress * -1.2f, -0.75f);
        float g = class_3532.method_15355(swingProgress);
        float h = class_3532.method_15374(g * (float)Math.PI);
        float i = -0.5f * h;
        float j = 0.4f * class_3532.method_15374(g * ((float)Math.PI * 2));
        float k = -0.3f * class_3532.method_15374(swingProgress * (float)Math.PI);
        matrices.method_46416(f * i, j - 0.3f * h, k);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(h * -45.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(f * h * -30.0f));
        this.renderFirstPersonSlimeMap(matrices, vertexConsumers, light, stack);
        matrices.method_22909();
    }

    @Unique
    private void renderSlimeMapInBothHands(class_4587 matrices, class_4597 vertexConsumers, int light, float pitch, float equipProgress, float swingProgress) {
        float f = class_3532.method_15355(swingProgress);
        float g = -0.2f * class_3532.method_15374(swingProgress * (float) Math.PI);
        float h = -0.4f * class_3532.method_15374(f * (float) Math.PI);
        matrices.method_46416(0.0f, -g / 2.0f, h);
        float i = this.getMapAngle(pitch);
        matrices.method_46416(0.0f, 0.04f + equipProgress * -1.2f + i * -0.5f, -0.72f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(i * -85.0f));
        assert this.client.field_1724 != null;
        if (!this.client.field_1724.method_5767()) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            this.renderArm(matrices, vertexConsumers, light, class_1306.field_6183);
            this.renderArm(matrices, vertexConsumers, light, class_1306.field_6182);
            matrices.method_22909();
        }
        float j = class_3532.method_15374(f * (float)Math.PI);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(j * 20.0f));
        matrices.method_22905(2.0f, 2.0f, 2.0f);
        this.renderFirstPersonSlimeMap(matrices, vertexConsumers, light, this.mainHand);
    }

    @Unique
    private void renderFirstPersonSlimeMap(class_4587 matrices, class_4597 vertexConsumers, int swingProgress, class_1799 stack) {
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrices.method_22905(0.38f, 0.38f, 0.38f);
        matrices.method_46416(-0.5f, -0.5f, 0.0f);
        matrices.method_22905(0.0078125f, 0.0078125f, 0.0078125f);
        Integer integer = FilledSlimeMapItem.method_8003(stack);
        class_22 mapState = FilledSlimeMapItem.method_7997(integer, this.client.field_1687);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(mapState == null ? SLIME_MAP_BACKGROUND : SLIME_MAP_BACKGROUND_CHECKERBOARD);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, -7.0f, 135.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22916(swingProgress).method_1344();
        vertexConsumer.method_22918(matrix4f, 135.0f, 135.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22916(swingProgress).method_1344();
        vertexConsumer.method_22918(matrix4f, 135.0f, -7.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22916(swingProgress).method_1344();
        vertexConsumer.method_22918(matrix4f, -7.0f, -7.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22916(swingProgress).method_1344();
        if (mapState != null) {
            this.client.field_1773.method_3194().method_1773(matrices, vertexConsumers, integer, mapState, false, swingProgress);
        }
    }

    @Inject(method = "renderFirstPersonItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal = 0))
    private void renderFirstPersonItemInject(class_742 player, float tickDelta, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci, @Local(ordinal = 0) boolean bl, @Local(ordinal = 0) class_1306 arm) {
        if (item.method_31574(ModItems.FILLED_SLIME_MAP)) {
            if (bl && this.offHand.method_7960()) {
                this.renderSlimeMapInBothHands(matrices, vertexConsumers, light, pitch, equipProgress, swingProgress);
            } else {
                this.renderSlimeMapInOneHand(matrices, vertexConsumers, light, equipProgress, arm, swingProgress, item);
            }
        }
    }
}