package fr.kolala.slimemap.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import fr.kolala.slimemap.item.FilledSlimeMapItem;
import fr.kolala.slimemap.item.ModItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.OptionalInt;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;

@Mixin(class_1533.class)
public abstract class ItemFrameEntityMixin extends class_1530 {
    @Shadow public abstract class_1799 getHeldItemStack();

    protected ItemFrameEntityMixin(class_1299<? extends class_1530> type, class_1937 world, class_2338 pos) {
        super(type, world, pos);
    }

    @Inject(method = "getMapId", at = @At("TAIL"), cancellable = true)
    public void getMapIdInject(CallbackInfoReturnable<OptionalInt> cir) {
        Integer integer1;
        class_1799 itemStack1 = this.getHeldItemStack();
        if (itemStack1.method_31574(ModItems.FILLED_SLIME_MAP) && (integer1 = FilledSlimeMapItem.method_8003(itemStack1)) != null) {
            cir.setReturnValue(OptionalInt.of(integer1));
        }
    }

    @Inject(method = "interact", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal = 0), cancellable = true)
    public void interactInject(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir, @Local(ordinal = 0)class_1799 itemStack) {
        class_22 mapState1;
        if (itemStack.method_31574(ModItems.FILLED_SLIME_MAP)) {
            if ((mapState1 = FilledSlimeMapItem.method_8001(itemStack, this.method_37908())) != null && mapState1.method_37343(256)) {
                cir.setReturnValue(class_1269.field_5814);
            }
        }
    }
}