package fr.kolala.slimemap.screen;

import fr.kolala.slimemap.item.FilledSlimeMapItem;
import fr.kolala.slimemap.item.ModItems;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3917;

public class CustomCartographyTableScreenHandler extends class_1703 {
    public static final int MAP_SLOT_INDEX = 0;
    public static final int MATERIAL_SLOT_INDEX = 1;
    public static final int RESULT_SLOT_INDEX = 2;
    private static final int INVENTORY_START = 3;
    private static final int INVENTORY_END = 30;
    private static final int HOTBAR_START = 30;
    private static final int HOTBAR_END = 39;
    private final class_3914 context;
    long lastTakeResultTime;
    public final class_1263 inventory = new class_1277(2){

        @Override
        public void method_5431() {
            CustomCartographyTableScreenHandler.this.method_7609(this);
            super.method_5431();
        }
    };
    private final class_1731 resultInventory = new class_1731(){

        @Override
        public void method_5431() {
            CustomCartographyTableScreenHandler.this.method_7609(this);
            super.method_5431();
        }
    };

    public CustomCartographyTableScreenHandler(int syncId, class_1661 inventory, class_3914 context) {
        super(class_3917.field_17343, syncId);
        int i;
        this.context = context;
        this.method_7621(new class_1735(this.inventory, MAP_SLOT_INDEX, 15, 15){

            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(class_1802.field_8204) || stack.method_31574(ModItems.FILLED_SLIME_MAP);
            }
        });
        this.method_7621(new class_1735(this.inventory, MATERIAL_SLOT_INDEX, 15, 52){

            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(class_1802.field_8407) || stack.method_31574(class_1802.field_8895) || stack.method_31574(class_1802.field_8141) || stack.method_31574(class_1802.field_8777) || stack.method_31574(ModItems.SLIME_MAP);
            }
        });
        this.method_7621(new class_1735(this.resultInventory, RESULT_SLOT_INDEX, 145, 39){

            @Override
            public boolean method_7680(class_1799 stack) {
                return false;
            }

            @Override
            public void method_7667(class_1657 player, class_1799 stack) {
                CustomCartographyTableScreenHandler.this.field_7761.get(MAP_SLOT_INDEX).method_7671(1);
                CustomCartographyTableScreenHandler.this.field_7761.get(MATERIAL_SLOT_INDEX).method_7671(1);
                stack.method_7909().method_54465(stack, player.method_37908(), player);
                context.method_17393((world, pos) -> {
                    long l = world.method_8510();
                    if (CustomCartographyTableScreenHandler.this.lastTakeResultTime != l) {
                        world.method_8396(null, pos, class_3417.field_17484, class_3419.field_15245, 1.0f, 1.0f);
                        CustomCartographyTableScreenHandler.this.lastTakeResultTime = l;
                    }
                });
                super.method_7667(player, stack);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735(inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(inventory, i, 8 + i * 18, 142));
        }
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return CustomCartographyTableScreenHandler.method_17695(this.context, player, class_2246.field_16336);
    }

    @Override
    public void method_7609(class_1263 inventory) {
        class_1799 itemStack = this.inventory.method_5438(MAP_SLOT_INDEX);
        class_1799 itemStack2 = this.inventory.method_5438(MATERIAL_SLOT_INDEX);
        class_1799 itemStack3 = this.resultInventory.method_5438(RESULT_SLOT_INDEX);
        if (!itemStack3.method_7960() && (itemStack.method_7960() || itemStack2.method_7960())) {
            this.resultInventory.method_5441(2);
        } else if (!itemStack.method_7960() && !itemStack2.method_7960()) {
            this.updateResult(itemStack, itemStack2, itemStack3);
        }
    }

    private void updateResult(class_1799 map, class_1799 item, class_1799 oldResult) {
        this.context.method_17393((world, pos) -> {
            class_1799 itemStack4;
            boolean isSlimeMap = map.method_31574(ModItems.FILLED_SLIME_MAP);
            class_22 mapState = isSlimeMap ?
                    FilledSlimeMapItem.method_8001(map, world) :
                    class_1806.method_8001(map, world);
            if (mapState == null) {
                return;
            }

            if ((isSlimeMap && item.method_31574(class_1802.field_8777) || !isSlimeMap && item.method_31574(class_1802.field_8407))
                    && !mapState.field_17403 && mapState.field_119 < 4) {
                itemStack4 = map.method_46651(1);
                itemStack4.method_7948().method_10569("map_scale_direction", 1);
                this.method_7623();
            } else if (item.method_31574(class_1802.field_8141) && !mapState.field_17403) {
                itemStack4 = map.method_46651(1);
                itemStack4.method_7948().method_10556("map_to_lock", true);
                this.method_7623();
            } else if ((isSlimeMap && item.method_31574(ModItems.SLIME_MAP)) || (!isSlimeMap && item.method_31574(class_1802.field_8895))) {
                itemStack4 = map.method_46651(2);
                this.method_7623();
            } else {
                this.resultInventory.method_5441(RESULT_SLOT_INDEX);
                this.method_7623();
                return;
            }

            if (!class_1799.method_7973(itemStack4, oldResult)) {
                this.resultInventory.method_5447(RESULT_SLOT_INDEX, itemStack4);
                this.method_7623();
            }
        });
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.resultInventory && super.method_7613(stack, slot);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = this.field_7761.get(slot);
        if (slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if (slot == RESULT_SLOT_INDEX) {
                itemStack2.method_7909().method_54465(itemStack2, player.method_37908(), player);
                if (!this.method_7616(itemStack2, INVENTORY_START, HOTBAR_END, true)) {
                    return class_1799.field_8037;
                }
                slot2.method_7670(itemStack2, itemStack);
            } else if (slot == MATERIAL_SLOT_INDEX || slot == MAP_SLOT_INDEX ? !this.method_7616(itemStack2, INVENTORY_START, HOTBAR_END, false) : (itemStack2.method_31574(class_1802.field_8204) || itemStack2.method_31574(ModItems.FILLED_SLIME_MAP) ? !this.method_7616(itemStack2, MAP_SLOT_INDEX, MATERIAL_SLOT_INDEX, false) : (itemStack2.method_31574(class_1802.field_8407) || itemStack2.method_31574(class_1802.field_8895) || itemStack2.method_31574(class_1802.field_8141) || itemStack2.method_31574(ModItems.SLIME_MAP) || itemStack2.method_31574(class_1802.field_8777) ? !this.method_7616(itemStack2, MATERIAL_SLOT_INDEX, RESULT_SLOT_INDEX, false) : (slot >= INVENTORY_START && slot < INVENTORY_END ? !this.method_7616(itemStack2, HOTBAR_START, HOTBAR_END, false) : slot >= HOTBAR_START && slot < HOTBAR_END && !this.method_7616(itemStack2, INVENTORY_START, INVENTORY_END, false))))) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot2.method_53512(class_1799.field_8037);
            }
            slot2.method_7668();
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot2.method_7667(player, itemStack2);
            this.method_7623();
        }
        return itemStack;
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.resultInventory.method_5441(2);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }
}