/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.capability;

import com.sammy.minersdelight.setup.MDBlockEntities;
import de.cadentem.quality_food.capability.BlockData;
import de.cadentem.quality_food.capability.CapabilityHandler;
import de.cadentem.quality_food.compat.Compat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;

public class BlockDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Map<Long, LazyOptional<BlockData>> SERVER_CACHE = new HashMap<Long, LazyOptional<BlockData>>();
    private final BlockData data = new BlockData();
    private final LazyOptional<BlockData> instance = LazyOptional.of(() -> this.data);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        return capability == CapabilityHandler.BLOCK_DATA_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return ((BlockData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).serializeNBT();
    }

    public void deserializeNBT(CompoundTag tag) {
        ((BlockData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).deserializeNBT(tag);
    }

    public static LazyOptional<BlockData> getCapability(@Nullable BlockEntity entity) {
        if (entity == null || entity.m_58904_() == null || entity.m_58904_().m_5776_() || !BlockDataProvider.isValid(entity)) {
            return LazyOptional.empty();
        }
        long key = entity.m_58899_().m_121878_();
        LazyOptional capability = SERVER_CACHE.get(key);
        if (capability == null && (capability = entity.getCapability(CapabilityHandler.BLOCK_DATA_CAPABILITY)).isPresent()) {
            SERVER_CACHE.put(key, (LazyOptional<BlockData>)capability);
        }
        return capability;
    }

    public static boolean isValid(BlockEntity entity) {
        if (entity instanceof AbstractFurnaceBlockEntity) {
            return true;
        }
        if (Compat.isModLoaded("farmersdelight") && entity.m_58903_() == ModBlockEntityTypes.COOKING_POT.get()) {
            return true;
        }
        return Compat.isModLoaded("miners_delight") && entity.m_58903_() == MDBlockEntities.COPPER_POT.get();
    }
}

