/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.mixin.sophisticatedcore;

import com.llamalad7.mixinextras.sugar.Local;
import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.mixin.sophisticatedcore.CraftingUpgradeContainerAccess;
import de.cadentem.quality_food.util.ContainerUtils;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeContainer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={StorageContainerMenuBase.class})
public abstract class StorageContainerMenuBaseMixin
extends AbstractContainerMenu {
    @Shadow(remap=false)
    @Final
    protected Player player;

    @Shadow(remap=false)
    public abstract Optional<UpgradeContainerBase<?, ?>> getOpenContainer();

    protected StorageContainerMenuBaseMixin(@Nullable MenuType<?> type, int containerId) {
        super(type, containerId);
    }

    @ModifyVariable(method={"quickMoveStack"}, at=@At(value="STORE"), ordinal=2)
    private ItemStack quality_food$applyQuality(ItemStack stack, @Local Slot slot) {
        if (!(slot instanceof ResultSlot)) {
            return stack;
        }
        this.getOpenContainer().ifPresent(container -> {
            if (container instanceof CraftingUpgradeContainer) {
                CraftingUpgradeContainer craftingContainer = (CraftingUpgradeContainer)container;
                if (ServerConfig.isNoQualityRecipe(((CraftingUpgradeContainerAccess)craftingContainer).quality_food$getLastRecipe())) {
                    return;
                }
                Collection<ItemStack> ingredients = ContainerUtils.getIngredients(craftingContainer.getSlots(), slotToCheck -> !(slotToCheck instanceof ResultSlot));
                QualityUtils.applyQuality(stack, ingredients, this.player);
            }
        });
        return stack;
    }
}

