/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.util;

import com.mojang.datafixers.util.Pair;
import de.cadentem.quality_food.compat.Compat;
import de.cadentem.quality_food.compat.SpecialContainer;
import de.cadentem.quality_food.config.QualityConfig;
import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.core.Modification;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import net.brdle.collectorsreap.common.block.FruitBushBlock;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.WildCropBlock;

public class QualityUtils {
    public static final String QUALITY_TAG = "quality_food";
    public static final String QUALITY_KEY = "quality";
    public static final String EFFECT_TAG = "effects";
    public static final String EFFECT_PROBABILITY_KEY = "chance";
    private static final RandomSource RANDOM = RandomSource.m_216327_();

    public static void applyQuality(ItemStack stack, Collection<ItemStack> ingredients, @Nullable Player player) {
        double totalWeight = 0.0;
        int validIngredients = 0;
        for (ItemStack ingredient : ingredients) {
            if (!Utils.isValidItem(ingredient)) continue;
            totalWeight += QualityConfig.getWeight(QualityUtils.getQuality(ingredient));
            ++validIngredients;
        }
        if (validIngredients == 0) {
            QualityUtils.applyQuality(stack, player);
            return;
        }
        Quality selected = Quality.NONE;
        double averageWeight = totalWeight / (double)validIngredients;
        for (Quality quality : Quality.values()) {
            if (quality.level() == 0) continue;
            double chance = QualityConfig.calculateChance(quality, averageWeight);
            chance = Modification.luck(player).apply(chance);
            if (!(chance > 0.0) || !(chance >= RANDOM.m_188500_())) continue;
            selected = quality;
        }
        QualityUtils.applyQuality(stack, selected);
    }

    public static void applyQuality(ItemStack stack, BlockState state, Quality blockQuality, @Nullable Player player, @Nullable BlockState farmland) {
        if (QualityUtils.isRelevantCrop(state)) {
            Quality selected = Quality.NONE;
            for (Quality quality : Quality.values()) {
                if (quality.level() == 0) continue;
                double chance = blockQuality.level() == 0 ? (double)QualityConfig.getChance(quality) : QualityConfig.calculateChance(quality, QualityConfig.getWeight(blockQuality));
                chance = Modification.harvestOrSeedMultiplier(quality, stack).apply(chance);
                chance = Modification.luck(player).apply(chance);
                chance = Modification.farmland(state, farmland).apply(chance);
                if (!(chance > 0.0) || !(chance >= RANDOM.m_188500_())) continue;
                selected = quality;
            }
            QualityUtils.applyQuality(stack, selected);
        } else if (QualityUtils.isValidQuality(blockQuality)) {
            QualityUtils.applyQuality(stack, blockQuality);
        } else if (blockQuality != Quality.NONE_PLAYER_PLACED) {
            QualityUtils.applyQuality(stack, player);
        }
    }

    public static void applyQuality(ItemStack stack, @Nullable Player player) {
        Quality selected = Quality.NONE;
        for (Quality quality : Quality.values()) {
            if (quality.level() == 0) continue;
            double chance = RANDOM.m_188500_();
            chance = Modification.luck(player).apply(chance);
            if (!(chance >= (double)(1.0f - QualityConfig.getChance(quality)))) continue;
            selected = quality;
        }
        QualityUtils.applyQuality(stack, selected);
    }

    public static void applyQuality(ItemStack stack, Quality quality) {
        QualityUtils.applyQuality(stack, quality, false);
    }

    public static void applyQuality(ItemStack stack, Quality quality, boolean canUpgrade) {
        if (!QualityUtils.isValidQuality(quality) || !Utils.isValidItem(stack)) {
            return;
        }
        if (!canUpgrade && QualityUtils.hasQuality(stack) || canUpgrade && QualityUtils.getQuality(stack).level() > quality.level()) {
            return;
        }
        CompoundTag qualityTag = new CompoundTag();
        qualityTag.m_128405_(QUALITY_KEY, quality.level());
        if (stack.getFoodProperties(null) != null) {
            QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
            ListTag effects = new ListTag();
            config.getEffects().forEach(effectConfig -> {
                if (effectConfig.test(stack) && RANDOM.m_188500_() <= effectConfig.getEffect().chance()) {
                    CompoundTag effectTag = new CompoundTag();
                    effectTag.m_128347_(EFFECT_PROBABILITY_KEY, effectConfig.getEffect().probability());
                    effects.add((Object)new MobEffectInstance(effectConfig.getEffect().effect(), effectConfig.getEffect().duration(), effectConfig.getEffect().amplifier()).m_19555_(effectTag));
                }
            });
            qualityTag.m_128365_(EFFECT_TAG, (Tag)effects);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(QUALITY_TAG, (Tag)qualityTag);
    }

    public static boolean isRelevantCrop(BlockState state) {
        CropBlock crop;
        Block block = state.m_60734_();
        if (block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(state)) {
            return true;
        }
        if (Compat.isModLoaded("farmersdelight") && state.m_60734_() instanceof WildCropBlock) {
            return true;
        }
        if (Compat.isModLoaded("collectorsreap") && state.m_60734_() instanceof FruitBushBlock && (Integer)state.m_61143_((Property)FruitBushBlock.AGE) == 4) {
            return true;
        }
        return Compat.isModLoaded("farm_and_charm") && state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)Compat.location("farm_and_charm", "wild_crops")));
    }

    public static void handleConversion(@NotNull ItemStack result, @NotNull Container container, @Nullable Recipe<?> recipe, @Nullable RegistryAccess access) {
        boolean shouldRetainQuality = ServerConfig.isRetainQualityRecipe(recipe, access);
        boolean handleCompacting = (Boolean)ServerConfig.HANDLE_COMPACTING.get();
        if (!shouldRetainQuality && !handleCompacting) {
            return;
        }
        Pair<HashMap<Item, Integer>, int[]> data = QualityUtils.getContainerData(container);
        int relevantItemCount = ((HashMap)data.getFirst()).entrySet().stream().mapToInt(entry -> {
            if (Utils.isValidItem(((Item)entry.getKey()).m_7968_())) {
                return (Integer)entry.getValue();
            }
            return 0;
        }).sum();
        Quality quality = QualityUtils.getQuality((int[])data.getSecond(), relevantItemCount);
        if (quality.level() > 0 && (shouldRetainQuality || QualityUtils.getCompactingSize((HashMap)data.getFirst(), container) == relevantItemCount || relevantItemCount == 1 && (result.m_41613_() == 4 || result.m_41613_() == 9))) {
            QualityUtils.applyQuality(result, quality);
        }
    }

    private static Pair<HashMap<Item, Integer>, int[]> getContainerData(Container container) {
        int[] qualities = new int[Quality.values().length];
        HashMap<Item, Integer> items = new HashMap<Item, Integer>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack containerStack = container.m_8020_(i);
            Item item = containerStack.m_41720_();
            if (container instanceof SpecialContainer) {
                items.put(item, items.getOrDefault(item, 0) + containerStack.m_41613_());
            } else {
                items.put(item, items.getOrDefault(item, 0) + 1);
            }
            if (!Utils.isValidItem(containerStack)) continue;
            if (container instanceof SpecialContainer) {
                int n = QualityUtils.getQuality(containerStack).ordinal();
                qualities[n] = qualities[n] + containerStack.m_41613_();
                continue;
            }
            int n = QualityUtils.getQuality(containerStack).ordinal();
            qualities[n] = qualities[n] + 1;
        }
        return Pair.of(items, (Object)qualities);
    }

    private static Quality getQuality(int[] qualities, int itemCount) {
        if (itemCount == 0) {
            return Quality.NONE;
        }
        for (int ordinal = Quality.DIAMOND.ordinal(); ordinal > 0; --ordinal) {
            if ((itemCount -= qualities[ordinal]) > 0) continue;
            return Quality.get(ordinal);
        }
        return Quality.NONE;
    }

    private static int getCompactingSize(HashMap<Item, Integer> items, Container container) {
        Set<Item> keys = items.keySet();
        if (!(keys.size() == 1 || keys.size() == 2 && keys.contains(Items.f_41852_))) {
            return -1;
        }
        int containerSize = container.m_6643_();
        for (Item key : keys) {
            int itemCount = items.get(key);
            if (container instanceof SpecialContainer) {
                if (key == Items.f_41852_) continue;
                if (itemCount == 4 || itemCount == 9) {
                    return itemCount;
                }
                return -1;
            }
            if (key == Items.f_41852_ && containerSize - itemCount - 4 != 0 && containerSize - itemCount - 9 != 0) {
                return -1;
            }
            if (key == Items.f_41852_ || itemCount != 4 && itemCount != 9) continue;
            return itemCount;
        }
        return -1;
    }

    public static float getCookingBonus(ItemStack stack, boolean considerStackSize) {
        Quality quality = QualityUtils.getQuality(stack);
        int stackSize = considerStackSize ? stack.m_41613_() : 1;
        return switch (quality) {
            case Quality.IRON -> (float)stackSize / 256.0f;
            case Quality.GOLD -> (float)stackSize / 128.0f;
            case Quality.DIAMOND -> (float)stackSize / 64.0f;
            default -> 0.0f;
        };
    }

    public static float getCookingBonus(ItemStack stack) {
        return QualityUtils.getCookingBonus(stack, false);
    }

    public static boolean hasQuality(ItemStack stack) {
        boolean hasTag;
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        boolean bl = hasTag = stack.m_41783_() != null && stack.m_41783_().m_128423_(QUALITY_TAG) != null;
        if (!hasTag) {
            return false;
        }
        return stack.m_41783_().m_128469_(QUALITY_TAG).m_128451_(QUALITY_KEY) != 0;
    }

    public static Quality getQuality(@Nullable ItemStack stack) {
        if (stack == null) {
            return Quality.NONE;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            CompoundTag qualityTag = tag.m_128469_(QUALITY_TAG);
            return Quality.get(qualityTag.m_128451_(QUALITY_KEY));
        }
        return Quality.NONE;
    }

    public static boolean isValidQuality(Quality quality) {
        return quality != null && quality != Quality.NONE && quality != Quality.NONE_PLAYER_PLACED;
    }
}

