package net.ramixin.visibletraders;

import com.mojang.serialization.Codec;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_3850;
import net.ramixin.visibletraders.threading.FutureMerchantOffer;
import net.ramixin.visibletraders.threading.SerializableListing;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LockedTradeData {

    private List<class_1916> lockedOffers;

    public LockedTradeData(class_1646 villager) {
        this.lockedOffers = generateTrades(villager);
    }

    private LockedTradeData(List<class_1916> offers) {
        this.lockedOffers = new ArrayList<>(offers);
    }

    public static @Nullable LockedTradeData constructOrNull(class_11368 valueInput, class_1297 entity) {
        Optional<List<class_1916>> maybeOffers = valueInput.method_71426("LockedOffers", class_1916.field_48850.listOf());
        if(maybeOffers.isEmpty()) return null;
        List<class_1916> offers = maybeOffers.get();
        Optional<List<Long>> maybeIndices = valueInput.method_71426("futureOfferIndices", Codec.LONG.listOf());
        if(maybeIndices.isPresent()) {
            List<int[]> indices = maybeIndices.get().stream().map(lung -> new int[]{(int) (lung >> 32), (int) (lung & 0xFF_FF_FF_FFL)}).toList();
            Optional<List<SerializableListing>> maybeListings = valueInput.method_71426("futureOffers", VisibleTraders.CODEC.listOf());
            if(maybeListings.isEmpty()) return null;
            List<SerializableListing> listings = maybeListings.get();
            if(listings.size() != indices.size()) return null;
            for(int i = 0; i < listings.size(); i++) {
                SerializableListing listing = listings.get(i);
                int[] index = indices.get(i);
                if(index[0] >= offers.size()) return null;
                class_1916 offerSet = offers.get(index[0]);
                FutureMerchantOffer futureOffer = new FutureMerchantOffer(listing, () -> listing.visibleTrades$buildOffer(entity, entity.method_59922()));
                VisibleTraders.TRADE_WORKER.addOrder(futureOffer);
                offerSet.add(index[1], futureOffer);
            }
        }
        return new LockedTradeData(offers);
    }

    private static ArrayList<class_1916> generateTrades(class_1646 villager) {
        class_1916 offers = villager.method_8264();
        class_3850 data = villager.method_7231();
        ArrayList<class_1916> lockedOffers = new ArrayList<>();
        int level = data.comp_3522();
        while(level < 5) {
            villager.method_7195(data.method_16920(++level));
            int prev = offers.size();
            villager.method_7237();
            int dif = offers.size() - prev;
            class_1916 newOffers = new class_1916();
            for(int i = 0; i < dif; i++) newOffers.add(offers.removeLast());
            lockedOffers.add(newOffers);
        }
        villager.method_7195(data);
        return lockedOffers;
    }

    public void write(class_11372 valueOutput) {
        if(this.lockedOffers == null) return;
        List<class_1916> offersToWrite = new ArrayList<>();
        List<Long> futureOfferIndexes = new ArrayList<>();
        List<SerializableListing> futureOffers = new ArrayList<>();
        for (int i = 0; i < lockedOffers.size(); i++) {
            class_1916 offers = lockedOffers.get(i);
            class_1916 newOffers = new class_1916();
            for (int j = 0; j < offers.size(); j++) {
                class_1914 offer = offers.get(j);
                if (!(offer instanceof FutureMerchantOffer futureOffer)) newOffers.add(offer);
                else {
                    if (futureOffer.fulfilled())
                        newOffers.add(Objects.requireNonNull(futureOffer.getFuture(), "Future offers was null although fulfilled"));
                    else {
                        futureOfferIndexes.add(((long)i) << 32 | j);
                        futureOffers.add(futureOffer.getListing());
                    }
                }
            }
            offersToWrite.add(newOffers);
        }
        valueOutput.method_71468("LockedOffers", class_1916.field_48850.listOf(), offersToWrite);
        valueOutput.method_71468("futureOfferIndices", Codec.LONG.listOf(), futureOfferIndexes);
        valueOutput.method_71468("futureOffers", VisibleTraders.CODEC.listOf(), futureOffers);
    }

    public boolean hasNoOffers() {
        return this.lockedOffers.isEmpty();
    }

    public class_1916 popTradeSet() {
        if(this.lockedOffers == null || hasNoOffers()) return null;
        return this.lockedOffers.removeFirst();
    }

    public class_1916 buildLockedOffers() {
        class_1916 lockedOffers = new class_1916();
        if(this.lockedOffers == null) return lockedOffers;
        for(class_1916 listOffers : this.lockedOffers) for(class_1914 offer : listOffers) {
            if(offer.method_8250().method_7960() && !(offer instanceof FutureMerchantOffer)) {
                this.lockedOffers = new ArrayList<>();
                VisibleTraders.LOGGER.error("detected incomplete trade. Rebuilding locked offers");
                return new class_1916();
            }
            lockedOffers.add(offer);
        }
        return lockedOffers;
    }

    public void tick(class_1646 villager, Runnable popCallback) {
        if(this.lockedOffers == null) return;
        int requiredSets = 5 - villager.method_7231().comp_3522();
        while(requiredSets < this.lockedOffers.size()) popCallback.run();
        if(requiredSets > this.lockedOffers.size()) {
            VisibleTraders.LOGGER.error("detected missing locked trade sets. Rebuilding locked offers");
            this.lockedOffers = generateTrades(villager);
        }
    }
}
