package net.ramixin.visibletraders.mixins;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.ramixin.visibletraders.LockedTradeData;
import net.ramixin.visibletraders.ducks.VillagerDuck;
import net.ramixin.visibletraders.ducks.ZombieVillagerDuck;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;

@Mixin(class_1641.class)
public abstract class ZombieVillagerMixin extends class_1642 implements ZombieVillagerDuck {

    @Unique
    private final Mutable<LockedTradeData> lockedTradeData = new MutableObject<>();

    public ZombieVillagerMixin(class_1299<? extends class_1642> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Unique
    private void ifPresent(Consumer<LockedTradeData> consumer) {
        LockedTradeData val = lockedTradeData.getValue();
        if(val == null) return;
        consumer.accept(val);
    }

    @Inject(method = "addAdditionalSaveData", at = @At("HEAD"))
    private void saveLockedTradeData(class_11372 valueOutput, CallbackInfo ci) {
        ifPresent(data -> data.write(valueOutput));
    }

    @Inject(method = "readAdditionalSaveData", at = @At("TAIL"))
    private void readLockedTradeData(class_11368 valueInput, CallbackInfo ci) {
        lockedTradeData.setValue(LockedTradeData.constructOrNull(valueInput, this));
    }

    @Inject(method = "method_63659", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/npc/Villager;setVillagerXp(I)V"))
    private void transferTradesToVillager(class_3218 serverLevel, class_1646 villager, CallbackInfo ci) {
        VillagerDuck.of(villager).visibleTraders$setLockedTradeData(lockedTradeData.getValue());
    }

    @Override
    public void visibleTraders$setLockedTradeData(LockedTradeData data) {
        this.lockedTradeData.setValue(data);
    }
}
