/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.visibletraders.mixins;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_3850;
import net.minecraft.class_3851;
import net.minecraft.class_3988;
import net.minecraft.class_4094;
import net.ramixin.visibletraders.LockedTradeData;
import net.ramixin.visibletraders.ducks.VillagerDuck;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1646.class})
public abstract class VillagerMixin
extends class_3988
implements class_4094,
class_3851,
VillagerDuck {
    @Unique
    private final Mutable<LockedTradeData> lockedTradeData = new MutableObject();

    @Shadow
    @NotNull
    public abstract class_3850 method_7231();

    public VillagerMixin(class_1299<? extends class_3988> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Unique
    private void ifPresent(Consumer<LockedTradeData> consumer) {
        LockedTradeData val = (LockedTradeData)this.lockedTradeData.getValue();
        if (val == null) {
            return;
        }
        consumer.accept(val);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void saveLockedTradeData(class_11372 valueOutput, CallbackInfo ci) {
        this.ifPresent(data -> data.write(valueOutput));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readLockedTradeData(class_11368 valueInput, CallbackInfo ci) {
        this.lockedTradeData.setValue((Object)LockedTradeData.constructOrNull(valueInput, (class_1297)this));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void removeLockedTradeDataIfNoOffers(CallbackInfo ci) {
        if (this.field_17721 == null) {
            this.lockedTradeData.setValue(null);
        }
        this.ifPresent(data -> data.tick((class_1646)this, this::appendLockedOffer));
    }

    @Inject(method={"updateTrades"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventAdditionalTradesOnRankIncrease(CallbackInfo ci) {
        if (this.field_17721 == null || this.field_17721.isEmpty()) {
            this.lockedTradeData.setValue(null);
            return;
        }
        if (this.appendLockedOffer()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean appendLockedOffer() {
        if (this.field_17721 == null) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        this.ifPresent(data -> {
            class_1916 dismissedTrades = data.popTradeSet();
            if (dismissedTrades != null) {
                this.field_17721.addAll((Collection)dismissedTrades);
                result.set(true);
            }
        });
        return result.get();
    }

    @Override
    public void visibleTraders$setLockedTradeData(LockedTradeData data) {
        this.lockedTradeData.setValue((Object)data);
    }

    @Override
    public Optional<LockedTradeData> visibleTraders$getLockedTradeData() {
        return Optional.ofNullable((LockedTradeData)this.lockedTradeData.getValue());
    }

    @Override
    public void visibleTrades$regenerateTrades() {
        this.lockedTradeData.setValue((Object)new LockedTradeData((class_1646)this));
    }

    @Override
    public int visibleTraders$getShiftedLevel() {
        int level = this.method_7231().comp_3522();
        if (this.field_17721 == null) {
            return level;
        }
        return level | this.field_17721.size() << 8;
    }

    @Override
    public class_1916 visibleTraders$getCombinedOffers() {
        class_1916 offers = new class_1916();
        offers.addAll((Collection)this.field_17721);
        if (this.lockedTradeData.getValue() == null) {
            this.visibleTrades$regenerateTrades();
        }
        this.ifPresent(data -> offers.addAll((Collection)data.buildLockedOffers()));
        return offers;
    }
}

