/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.visibletraders.threading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ramixin.visibletraders.VisibleTraders;
import net.ramixin.visibletraders.threading.FutureMerchantOffer;

public class TradeWorker
implements Runnable {
    private final List<FutureMerchantOffer> pendingOrders = Collections.synchronizedList(new ArrayList());
    private boolean running = true;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        VisibleTraders.LOGGER.info("Starting trade worker");
        while (this.running) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            while (!this.pendingOrders.isEmpty()) {
                FutureMerchantOffer order = this.pendingOrders.getFirst();
                order.fulfillFuture();
                this.pendingOrders.remove((Object)order);
            }
        }
        VisibleTraders.LOGGER.info("Thread closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addOrder(FutureMerchantOffer order) {
        this.pendingOrders.add(order);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        VisibleTraders.LOGGER.info("Stopping trade worker");
        this.running = false;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void reset() {
        this.pendingOrders.clear();
        this.running = true;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }
}

