/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copis_homes_mod;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class Copis_homes_mod
implements ModInitializer {
    public static final String MOD_ID = "copis_homes_mod";
    private final Map<UUID, Map<String, class_2338>> homes = new HashMap<UUID, Map<String, class_2338>>();
    private final Map<UUID, Long> lastTeleport = new HashMap<UUID, Long>();
    private final Map<UUID, TeleportTask> teleporting = new HashMap<UUID, TeleportTask>();
    private static final long TELEPORT_COOLDOWN = 30000L;
    private static final int TELEPORT_DELAY = 5;
    private final Gson gson = new Gson();
    private final File saveFile = new File("config", "copis_homes.json");

    public void onInitialize() {
        this.loadHomes();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
                this.setHome(player, name);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"home").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
                String name;
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                return this.teleportHome(player, name = StringArgumentType.getString((CommandContext)ctx, (String)"name")) ? 1 : 0;
            })));
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> this.teleporting.values().removeIf(TeleportTask::tick));
    }

    private void setHome(class_3222 player, String name) {
        UUID uuid = player.method_5667();
        this.homes.putIfAbsent(uuid, new HashMap());
        this.homes.get(uuid).put(name, player.method_24515());
        player.method_7353(class_2561.method_30163((String)("\u00a7aHome '" + name + "' set!")), false);
        this.saveHomes();
    }

    private boolean teleportHome(class_3222 player, String name) {
        UUID uuid = player.method_5667();
        Map<String, class_2338> userHomes = this.homes.get(uuid);
        if (userHomes == null || !userHomes.containsKey(name)) {
            player.method_7353(class_2561.method_30163((String)("\u00a7cHome '" + name + "' not found!")), false);
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.lastTeleport.getOrDefault(uuid, 0L) + 30000L > now) {
            long wait = (this.lastTeleport.get(uuid) + 30000L - now) / 1000L;
            player.method_7353(class_2561.method_30163((String)("\u00a7cYou must wait " + wait + " seconds before teleporting again.")), false);
            return false;
        }
        this.teleporting.put(uuid, new TeleportTask(player, userHomes.get(name), 5));
        player.method_7353(class_2561.method_30163((String)("\u00a7eTeleporting to home '" + name + "' in 5 seconds. Stand still!")), false);
        return true;
    }

    private void saveHomes() {
        try {
            if (!this.saveFile.getParentFile().exists()) {
                this.saveFile.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(this.saveFile);
            this.gson.toJson(this.homes, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadHomes() {
        try {
            if (!this.saveFile.exists()) {
                return;
            }
            FileReader reader = new FileReader(this.saveFile);
            Type type = new TypeToken<Map<String, Map<String, class_2338>>>(this){}.getType();
            Map raw = (Map)this.gson.fromJson((Reader)reader, type);
            reader.close();
            if (raw != null) {
                raw.forEach((k, v) -> this.homes.put(UUID.fromString(k), (Map<String, class_2338>)v));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TeleportTask {
        private final class_3222 player;
        private final class_2338 destination;
        private int ticksLeft;
        private final class_2338 startPos;

        public TeleportTask(class_3222 player, class_2338 destination, int delaySeconds) {
            this.player = player;
            this.destination = destination;
            this.ticksLeft = delaySeconds * 20;
            this.startPos = player.method_24515();
        }

        public boolean tick() {
            class_3218 world;
            if (!this.player.method_5805()) {
                return true;
            }
            if (!this.player.method_24515().equals((Object)this.startPos)) {
                this.player.method_7353(class_2561.method_30163((String)"\u00a7cTeleport cancelled because you moved!"), false);
                return true;
            }
            if (this.ticksLeft % 20 == 0) {
                world = (class_3218)this.player.method_37908();
                for (int i = 0; i < 10; ++i) {
                    world.method_8406((class_2394)class_2398.field_11214, this.player.method_23317() + (Math.random() - 0.5), this.player.method_23318() + 1.0 + Math.random(), this.player.method_23321() + (Math.random() - 0.5), 0.0, 0.1, 0.0);
                }
                this.player.method_5783(class_3417.field_14802, 1.0f, 1.0f);
            }
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                world = (class_3218)this.player.method_37908();
                if (world.method_22347(this.destination) && world.method_22347(this.destination.method_10084())) {
                    this.player.method_14251(world, (double)this.destination.method_10263() + 0.5, (double)this.destination.method_10264(), (double)this.destination.method_10260() + 0.5, this.player.method_36454(), this.player.method_36455());
                    Copis_homes_mod.this.lastTeleport.put(this.player.method_5667(), System.currentTimeMillis());
                    this.player.method_7353(class_2561.method_30163((String)"\u00a7aTeleported to home!"), false);
                } else {
                    this.player.method_7353(class_2561.method_30163((String)"\u00a7cTeleport failed: destination blocked!"), false);
                }
                return true;
            }
            return false;
        }
    }
}

