/*
 * Decompiled with CFR 0.152.
 */
package com.astrazoey.nopearldamage;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("no_pearl_damage.properties");
    private static final String CRACKED_PEARL_COOLDOWN = "cracked-pearl-cooldown";
    public static int crackedPearlCooldown = 1;
    private static final String CRACKED_PEARL_DAMAGE = "cracked-pearl-damage";
    public static float crackedPearlDamage = 5.0f;
    private static final String CRACKED_PEARL_STACK_SIZE = "cracked-pearl-stack-size";
    public static int crackedPearlStackSize = 64;
    private static final String CRACKED_PEARL_ENDERMITE_CHANCE = "cracked-pearl-endermite-chance";
    public static float crackedPearlEndermiteChance = 0.2f;
    private static final String ENDER_PEARL_COOLDOWN = "ender-pearl-cooldown";
    public static int enderPearlCooldown = 20;
    private static final String ENDER_PEARL_ENDERMITE_CHANCE = "ender-pearl-endermite-chance";
    public static float enderPearlEndermiteChance = 0.02f;

    public static void save() {
        Properties props = new Properties();
        Config.read(props);
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try (OutputStream out = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
            props.store(out, "No Pearl Damage Configuration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        Properties props = new Properties();
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
                Config.save();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try (InputStream stream = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
            props.load(stream);
            Config.assign(props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void read(Properties props) {
        props.setProperty(CRACKED_PEARL_COOLDOWN, String.valueOf(crackedPearlCooldown));
        props.setProperty(CRACKED_PEARL_DAMAGE, String.valueOf(crackedPearlDamage));
        props.setProperty(CRACKED_PEARL_STACK_SIZE, String.valueOf(crackedPearlStackSize));
        props.setProperty(CRACKED_PEARL_ENDERMITE_CHANCE, String.valueOf(crackedPearlEndermiteChance));
        props.setProperty(ENDER_PEARL_ENDERMITE_CHANCE, String.valueOf(enderPearlEndermiteChance));
    }

    public static void assign(Properties props) {
        crackedPearlCooldown = Config.defaultInteger(props.getProperty(CRACKED_PEARL_COOLDOWN), 1);
        crackedPearlDamage = Config.defaultFloat(props.getProperty(CRACKED_PEARL_DAMAGE), 5.0f);
        crackedPearlStackSize = Config.defaultInteger(props.getProperty(CRACKED_PEARL_STACK_SIZE), 64);
        crackedPearlEndermiteChance = Config.defaultFloat(props.getProperty(CRACKED_PEARL_ENDERMITE_CHANCE), 0.2f);
        enderPearlEndermiteChance = Config.defaultFloat(props.getProperty(ENDER_PEARL_ENDERMITE_CHANCE), 0.0f);
    }

    private static int defaultInteger(String amount, int defaultOption) {
        return amount == null ? defaultOption : Integer.parseInt(amount);
    }

    private static float defaultFloat(String amount, float defaultOption) {
        return amount == null ? defaultOption : Float.parseFloat(amount);
    }
}

