/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.maiminhdung.customenderchest.ConfigHandler;
import org.maiminhdung.customenderchest.bstats.Metrics;
import org.maiminhdung.customenderchest.commands.EnderChestCommand;
import org.maiminhdung.customenderchest.data.EnderChestManager;
import org.maiminhdung.customenderchest.listeners.PlayerListener;
import org.maiminhdung.customenderchest.locale.LocaleManager;
import org.maiminhdung.customenderchest.storage.StorageManager;
import org.maiminhdung.customenderchest.utils.SoundHandler;

public final class EnderChest
extends JavaPlugin {
    private static EnderChest instance;
    private ConfigHandler configHandler;
    private EnderChestManager enderChestManager;
    private LocaleManager localeManager;
    private SoundHandler soundHandler;
    private StorageManager storageManager;

    public void onEnable() {
        instance = this;
        this.configHandler = new ConfigHandler(this);
        this.localeManager = new LocaleManager(this);
        this.soundHandler = new SoundHandler(this);
        this.storageManager = new StorageManager(this);
        this.enderChestManager = new EnderChestManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        EnderChestCommand commandExecutor = new EnderChestCommand(this);
        PluginCommand command = this.getCommand("customenderchest");
        if (command != null) {
            command.setExecutor((CommandExecutor)commandExecutor);
            command.setTabCompleter((TabCompleter)commandExecutor);
        }
        this.setupBtatsMetrics();
        this.getLogger().info("CustomEnderChest has been enabled successfully!");
    }

    private void setupBtatsMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 26551);
    }

    public void onDisable() {
        if (this.enderChestManager != null) {
            this.enderChestManager.shutdown();
        }
        this.getLogger().info("CustomEnderChest has been disabled.");
    }

    public static EnderChest getInstance() {
        return instance;
    }

    public ConfigHandler config() {
        return this.configHandler;
    }

    public EnderChestManager getEnderChestManager() {
        return this.enderChestManager;
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public SoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }
}

