/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.lib.h2.table;

import java.util.ArrayList;
import java.util.List;
import org.maiminhdung.customenderchest.lib.h2.command.Prepared;
import org.maiminhdung.customenderchest.lib.h2.command.QueryScope;
import org.maiminhdung.customenderchest.lib.h2.command.query.AllColumnsForPlan;
import org.maiminhdung.customenderchest.lib.h2.command.query.Query;
import org.maiminhdung.customenderchest.lib.h2.engine.Database;
import org.maiminhdung.customenderchest.lib.h2.engine.SessionLocal;
import org.maiminhdung.customenderchest.lib.h2.index.Index;
import org.maiminhdung.customenderchest.lib.h2.index.QueryExpressionIndex;
import org.maiminhdung.customenderchest.lib.h2.index.RegularQueryExpressionIndex;
import org.maiminhdung.customenderchest.lib.h2.message.DbException;
import org.maiminhdung.customenderchest.lib.h2.result.SortOrder;
import org.maiminhdung.customenderchest.lib.h2.schema.Schema;
import org.maiminhdung.customenderchest.lib.h2.table.Column;
import org.maiminhdung.customenderchest.lib.h2.table.QueryExpressionTable;
import org.maiminhdung.customenderchest.lib.h2.table.Table;
import org.maiminhdung.customenderchest.lib.h2.table.TableFilter;
import org.maiminhdung.customenderchest.lib.h2.table.TableType;
import org.maiminhdung.customenderchest.lib.h2.util.StringUtils;
import org.maiminhdung.customenderchest.lib.h2.util.Utils;

public final class TableView
extends QueryExpressionTable {
    private String querySQL;
    private Column[] columnTemplates;
    private DbException createException;

    public TableView(Schema schema, int n, String string, String string2, Column[] columnArray, SessionLocal sessionLocal) {
        super(schema, n, string);
        this.init(string2, columnArray, sessionLocal);
    }

    @Override
    protected QueryExpressionIndex createIndex(SessionLocal sessionLocal, int[] nArray) {
        return new RegularQueryExpressionIndex(this, this.querySQL, null, sessionLocal, nArray);
    }

    public void replace(String string, Column[] columnArray, SessionLocal sessionLocal, boolean bl) {
        String string2 = this.querySQL;
        Column[] columnArray2 = this.columnTemplates;
        this.init(string, columnArray, sessionLocal);
        DbException dbException = this.recompile(sessionLocal, bl, true);
        if (dbException != null) {
            this.init(string2, columnArray2, sessionLocal);
            this.recompile(sessionLocal, true, false);
            throw dbException;
        }
    }

    private synchronized void init(String string, Column[] columnArray, SessionLocal sessionLocal) {
        this.querySQL = string;
        this.columnTemplates = columnArray;
        this.initColumnsAndTables(sessionLocal);
    }

    private static Query compileViewQuery(SessionLocal sessionLocal, String string) {
        Prepared prepared;
        sessionLocal.setParsingCreateView(true);
        try {
            prepared = sessionLocal.prepare(string, false, false, null);
        }
        finally {
            sessionLocal.setParsingCreateView(false);
        }
        if (!(prepared instanceof Query)) {
            throw DbException.getSyntaxError(string, 0);
        }
        return (Query)prepared;
    }

    public synchronized DbException recompile(SessionLocal sessionLocal, boolean bl, boolean bl2) {
        block4: {
            try {
                TableView.compileViewQuery(sessionLocal, this.querySQL);
            }
            catch (DbException dbException) {
                if (bl) break block4;
                return dbException;
            }
        }
        ArrayList<TableView> arrayList = new ArrayList<TableView>(this.getDependentViews());
        this.initColumnsAndTables(sessionLocal);
        for (TableView tableView : arrayList) {
            DbException dbException = tableView.recompile(sessionLocal, bl, false);
            if (dbException == null || bl) continue;
            return dbException;
        }
        if (bl2) {
            TableView.clearIndexCaches(this.database);
        }
        return bl ? null : this.createException;
    }

    private void initColumnsAndTables(SessionLocal sessionLocal) {
        Column[] columnArray;
        this.removeCurrentViewFromOtherTables();
        try {
            Query query = TableView.compileViewQuery(sessionLocal, this.querySQL);
            this.querySQL = query.getPlanSQL(0);
            this.tables = new ArrayList<Table>(query.getTables());
            columnArray = this.initColumns(sessionLocal, this.columnTemplates, query, false);
            this.createException = null;
            this.viewQuery = query;
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 90156) {
                throw dbException;
            }
            dbException.addSQL(this.getCreateSQL());
            this.createException = dbException;
            this.tables = Utils.newSmallArrayList();
            columnArray = new Column[]{};
        }
        this.setColumns(columnArray);
        if (this.getId() != 0) {
            this.addDependentViewToTables();
        }
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public Query getTopQuery() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return this.getSQL(new StringBuilder("DROP VIEW IF EXISTS "), 0).append(" CASCADE").toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQL(false, true, string);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean bl, boolean bl2) {
        return this.getCreateSQL(bl, bl2, this.getSQL(0));
    }

    private String getCreateSQL(boolean bl, boolean bl2, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        if (bl) {
            stringBuilder.append("OR REPLACE ");
        }
        if (bl2) {
            stringBuilder.append("FORCE ");
        }
        stringBuilder.append("VIEW ");
        stringBuilder.append(string);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        if (this.columns != null && this.columns.length > 0) {
            stringBuilder.append('(');
            Column.writeColumns(stringBuilder, this.columns, 0);
            stringBuilder.append(')');
        } else if (this.columnTemplates != null) {
            stringBuilder.append('(');
            Column.writeColumns(stringBuilder, this.columnTemplates, 0);
            stringBuilder.append(')');
        }
        return stringBuilder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.VIEW;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal sessionLocal) {
        this.removeCurrentViewFromOtherTables();
        super.removeChildrenAndResources(sessionLocal);
        this.querySQL = null;
        TableView.clearIndexCaches(this.database);
        this.invalidate();
    }

    public static void clearIndexCaches(Database database) {
        for (SessionLocal sessionLocal : database.getSessions(true)) {
            sessionLocal.clearViewIndexCache();
        }
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    @Override
    public QueryScope getQueryScope() {
        return null;
    }

    @Override
    public Index getScanIndex(SessionLocal sessionLocal, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        if (this.createException != null) {
            String string = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getTraceSQL(), string);
        }
        return super.getScanIndex(sessionLocal, nArray, tableFilterArray, n, sortOrder, allColumnsForPlan);
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null || this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        return super.getMaxDataModificationId();
    }

    private void removeCurrentViewFromOtherTables() {
        if (this.tables != null) {
            for (Table table : this.tables) {
                table.removeDependentView(this);
            }
            this.tables.clear();
        }
    }

    private void addDependentViewToTables() {
        for (Table table : this.tables) {
            table.addDependentView(this);
        }
    }

    @Override
    public boolean isDeterministic() {
        if (this.viewQuery == null) {
            return false;
        }
        return super.isDeterministic();
    }

    public List<Table> getTables() {
        return this.tables;
    }
}

