/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.maiminhdung.customenderchest.EnderChest;

public class ConfigHandler {
    private final EnderChest plugin;
    private FileConfiguration config;

    public ConfigHandler(EnderChest plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getString(String path) {
        return this.config.getString(path, "");
    }

    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    public double getDouble(String path, double def) {
        return this.config.getDouble(path, def);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public Component getMessage(String path) {
        String message = this.config.getString(path, "<red>Message not found: " + path + "</red>");
        return MiniMessage.miniMessage().deserialize((Object)message);
    }

    public Component getPrefixedMessage(String path) {
        String prefix = this.getString("messages.prefix", "<dark_purple>[<light_purple>EnderChest<dark_purple>] ");
        String message = this.config.getString(path, "<red>Message not found: " + path + "</red>");
        return MiniMessage.miniMessage().deserialize((Object)(prefix + message));
    }
}

