/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.listeners;

import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.data.EnderChestManager;

public class PlayerListener
implements Listener {
    private final EnderChest plugin;

    public PlayerListener(EnderChest plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent event) {
        this.plugin.getEnderChestManager().onPlayerJoin(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.plugin.getEnderChestManager().onPlayerQuit(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnderChestInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.ENDER_CHEST) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission("customec.level.0")) {
            event.setCancelled(true);
            this.plugin.getEnderChestManager().openEnderChest(player);
            this.plugin.getSoundHandler().playSound(player, "open");
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        EnderChestManager manager = this.plugin.getEnderChestManager();
        Inventory cachedInv = manager.getLoadedEnderChest(player.getUniqueId());
        if (event.getInventory().equals((Object)cachedInv)) {
            this.plugin.getSoundHandler().playSound(player, "close");
        }
    }
}

