/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.utils;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.locale.LocaleManager;
import org.maiminhdung.customenderchest.utils.Text;

public final class EnderChestUtils {
    private EnderChestUtils() {
    }

    public static int getSize(Player p) {
        if (p.hasPermission("customec.level.5")) {
            return 54;
        }
        if (p.hasPermission("customec.level.4")) {
            return 45;
        }
        if (p.hasPermission("customec.level.3")) {
            return 36;
        }
        if (p.hasPermission("customec.level.2")) {
            return 27;
        }
        if (p.hasPermission("customec.level.1")) {
            return 18;
        }
        if (p.hasPermission("customec.level.0")) {
            return 9;
        }
        return 0;
    }

    public static Component getTitle(Player p) {
        LocaleManager locale = EnderChest.getInstance().getLocaleManager();
        int levelIndex = EnderChestUtils.getSize(p) / 9 - 1;
        if (levelIndex < 0) {
            levelIndex = 0;
        }
        String levelNameString = locale.getRawString("levels." + levelIndex, "Level " + (levelIndex + 1));
        Component levelComponent = Text.parse(levelNameString, new TagResolver[0]);
        TagResolver placeholders = TagResolver.builder().resolver((TagResolver)Placeholder.component((String)"player", (ComponentLike)p.displayName())).resolver((TagResolver)Placeholder.component((String)"level", (ComponentLike)levelComponent)).build();
        return locale.getComponent("titles.enderchest", placeholders);
    }

    public static Component getAdminTitle(String targetName) {
        LocaleManager locale = EnderChest.getInstance().getLocaleManager();
        TagResolver.Single placeholder = Placeholder.component((String)"player", (ComponentLike)Component.text((String)targetName));
        return locale.getComponent("titles.admin_view", new TagResolver[]{placeholder});
    }
}

