/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.Scheduler;
import org.maiminhdung.customenderchest.data.ItemSerializer;

public class ConvertAllCommand
implements CommandExecutor {
    private final EnderChest plugin;
    private boolean isConverting = false;

    public ConvertAllCommand(EnderChest plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("CustomEnderChest.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (this.isConverting) {
            sender.sendMessage("\u00a7c[CustomEnderChest] Conversion is already in progress!");
            return true;
        }
        sender.sendMessage("\u00a7e[CustomEnderChest] ===============================================");
        sender.sendMessage("\u00a7e[CustomEnderChest] Starting database conversion...");
        sender.sendMessage("\u00a7e[CustomEnderChest] This will convert ALL player data to new format.");
        sender.sendMessage("\u00a7e[CustomEnderChest] \u00a7cDO NOT STOP THE SERVER during this process!");
        sender.sendMessage("\u00a7e[CustomEnderChest] ===============================================");
        this.isConverting = true;
        Scheduler.runTaskAsync(() -> {
            try {
                this.convertAllData(sender);
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7c[CustomEnderChest] \u00a74CRITICAL ERROR during conversion!");
                this.plugin.getLogger().severe("Failed to convert database: " + e.getMessage());
                this.plugin.getLogger().severe("Stack trace:");
                for (StackTraceElement element : e.getStackTrace()) {
                    this.plugin.getLogger().severe("  at " + element.toString());
                }
                this.isConverting = false;
            }
        });
        return true;
    }

    private void convertAllData(CommandSender sender) {
        String tableName = this.plugin.config().getString("storage.table_name", "custom_enderchests");
        try (Connection conn = this.plugin.getStorageManager().getConnection();){
            String selectSql = "SELECT player_uuid, player_name, chest_data FROM " + tableName;
            PreparedStatement selectPs = conn.prepareStatement(selectSql);
            ResultSet rs = selectPs.executeQuery();
            ArrayList<PlayerData> playerDataList = new ArrayList<PlayerData>();
            sender.sendMessage("\u00a7e[CustomEnderChest] Loading player data from database...");
            while (rs.next()) {
                String uuidStr = rs.getString("player_uuid");
                String playerName = rs.getString("player_name");
                String oldData = rs.getString("chest_data");
                if (oldData == null || oldData.isEmpty()) continue;
                playerDataList.add(new PlayerData(UUID.fromString(uuidStr), playerName, oldData));
            }
            rs.close();
            selectPs.close();
            sender.sendMessage("\u00a7e[CustomEnderChest] Found " + playerDataList.size() + " players with data.");
            sender.sendMessage("\u00a7e[CustomEnderChest] Starting conversion process...");
            AtomicInteger successCount = new AtomicInteger(0);
            AtomicInteger failCount = new AtomicInteger(0);
            AtomicInteger skippedCount = new AtomicInteger(0);
            AtomicInteger processedCount = new AtomicInteger(0);
            for (PlayerData playerData : playerDataList) {
                int processed;
                try {
                    ItemStack[] items = ItemSerializer.fromBase64(playerData.oldData);
                    if (items == null || items.length == 0) {
                        skippedCount.incrementAndGet();
                        this.plugin.getLogger().warning("Skipped empty data for player: " + playerData.playerName);
                        continue;
                    }
                    String newData = ItemSerializer.toBase64(items);
                    if (newData.equals(playerData.oldData)) {
                        skippedCount.incrementAndGet();
                        this.plugin.getLogger().info("Data already in new format for: " + playerData.playerName);
                    } else {
                        String updateSql = "UPDATE " + tableName + " SET chest_data = ? WHERE player_uuid = ?";
                        PreparedStatement updatePs = conn.prepareStatement(updateSql);
                        updatePs.setString(1, newData);
                        updatePs.setString(2, playerData.uuid.toString());
                        updatePs.executeUpdate();
                        updatePs.close();
                        successCount.incrementAndGet();
                        this.plugin.getLogger().info("Converted data for: " + playerData.playerName + " (" + items.length + " slots)");
                    }
                }
                catch (Exception e) {
                    failCount.incrementAndGet();
                    this.plugin.getLogger().severe("Failed to convert data for " + playerData.playerName + ": " + e.getMessage());
                }
                if ((processed = processedCount.incrementAndGet()) % 10 != 0 && processed != playerDataList.size()) continue;
                Scheduler.runTask(() -> sender.sendMessage("\u00a7e[CustomEnderChest] Progress: " + processed + "/" + playerDataList.size() + " (Success: " + successCount.get() + ", Failed: " + failCount.get() + ", Skipped: " + skippedCount.get() + ")"));
            }
            Scheduler.runTask(() -> {
                sender.sendMessage("\u00a7e[CustomEnderChest] ===============================================");
                sender.sendMessage("\u00a7a[CustomEnderChest] \u00a72CONVERSION COMPLETED!");
                sender.sendMessage("\u00a7a[CustomEnderChest] Total players: " + playerDataList.size());
                sender.sendMessage("\u00a7a[CustomEnderChest] \u00a72Successfully converted: " + successCount.get());
                sender.sendMessage("\u00a7e[CustomEnderChest] \u00a76Skipped (already new format): " + skippedCount.get());
                sender.sendMessage("\u00a7c[CustomEnderChest] \u00a74Failed: " + failCount.get());
                sender.sendMessage("\u00a7e[CustomEnderChest] ===============================================");
                if (successCount.get() > 0) {
                    sender.sendMessage("\u00a7a[CustomEnderChest] Your database has been converted to new format!");
                    sender.sendMessage("\u00a7a[CustomEnderChest] You can now safely upgrade to Minecraft 1.21.5+");
                }
                if (failCount.get() > 0) {
                    sender.sendMessage("\u00a7c[CustomEnderChest] Some players failed to convert.");
                    sender.sendMessage("\u00a7c[CustomEnderChest] Check console for details.");
                }
                this.isConverting = false;
            });
        }
        catch (Exception e) {
            Scheduler.runTask(() -> {
                sender.sendMessage("\u00a7c[CustomEnderChest] \u00a74CRITICAL ERROR during conversion!");
                sender.sendMessage("\u00a7c[CustomEnderChest] Error: " + e.getMessage());
                sender.sendMessage("\u00a7c[CustomEnderChest] Check console for full error details.");
            });
            this.plugin.getLogger().severe("Critical error during database conversion:");
            this.plugin.getLogger().severe("Error: " + e.getMessage());
            for (StackTraceElement element : e.getStackTrace()) {
                this.plugin.getLogger().severe("  at " + element.toString());
            }
            this.isConverting = false;
        }
    }

    private static class PlayerData {
        final UUID uuid;
        final String playerName;
        final String oldData;

        PlayerData(UUID uuid, String playerName, String oldData) {
            this.uuid = uuid;
            this.playerName = playerName;
            this.oldData = oldData;
        }
    }
}

