/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.Scheduler;
import org.maiminhdung.customenderchest.commands.ConvertAllCommand;
import org.maiminhdung.customenderchest.data.EnderChestManager;
import org.maiminhdung.customenderchest.data.LegacyImporter;
import org.maiminhdung.customenderchest.locale.LocaleManager;
import org.maiminhdung.customenderchest.storage.StorageInterface;
import org.maiminhdung.customenderchest.utils.DataLockManager;
import org.maiminhdung.customenderchest.utils.EnderChestUtils;

public final class EnderChestCommand
implements CommandExecutor,
TabCompleter {
    private final EnderChest plugin;
    private final LegacyImporter legacyImporter;
    private final StorageInterface storage;
    private final EnderChestManager manager;
    private final ConvertAllCommand convertAllCommand;

    public EnderChestCommand(EnderChest plugin) {
        this.plugin = plugin;
        this.legacyImporter = new LegacyImporter(plugin);
        this.storage = plugin.getStorageManager().getStorage();
        this.manager = plugin.getEnderChestManager();
        this.convertAllCommand = new ConvertAllCommand(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (args.length == 0) {
            return this.handleDefaultCommand(sender);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "open": {
                this.handleOpen(sender, args);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "importlegacy": {
                this.handleImport(sender);
                break;
            }
            case "delete": {
                this.handleDelete(sender, args, label);
                break;
            }
            case "convertall": {
                this.convertAllCommand.onCommand(sender, command, label, args);
                break;
            }
            default: {
                return this.handleDefaultCommand(sender);
            }
        }
        return true;
    }

    private boolean handleDefaultCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            this.plugin.getEnderChestManager().openEnderChest(p);
        } else {
            sender.sendMessage(this.plugin.getLocaleManager().getComponent("messages.players-only", new TagResolver[0]));
        }
        return true;
    }

    private void handleOpen(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLocaleManager().getComponent("messages.players-only", new TagResolver[0]));
            return;
        }
        Player p = (Player)sender;
        if (args.length == 1) {
            this.plugin.getEnderChestManager().openEnderChest(p);
            return;
        }
        if (args.length >= 2) {
            if (!p.hasPermission("CustomEnderChest.command.open.other")) {
                p.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.no-permission", new TagResolver[0]));
                return;
            }
            String targetName = args[1].trim();
            if (targetName.isEmpty()) {
                p.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.invalid-player", new TagResolver[0]));
                return;
            }
            this.openOtherPlayerChest(p, targetName);
        }
    }

    private void openOtherPlayerChest(Player admin, String targetName) {
        if (admin == null || !admin.isOnline()) {
            return;
        }
        admin.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.loading-chest", new TagResolver[]{Placeholder.unparsed((String)"player", (String)targetName)}));
        Player targetOnline = Bukkit.getPlayerExact((String)targetName);
        if (targetOnline != null) {
            Inventory liveInv = this.plugin.getEnderChestManager().getLoadedEnderChest(targetOnline.getUniqueId());
            if (liveInv == null) {
                admin.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.player-not-found", new TagResolver[]{Placeholder.unparsed((String)"player", (String)targetName)}));
                return;
            }
            Component title = EnderChestUtils.getAdminTitle(targetOnline.getName());
            Inventory adminView = Bukkit.createInventory((InventoryHolder)admin, (int)liveInv.getSize(), (Component)title);
            adminView.setContents(liveInv.getContents());
            this.plugin.getEnderChestManager().getAdminViewedChests().put(adminView, targetOnline.getUniqueId());
            admin.openInventory(adminView);
            this.plugin.getSoundHandler().playSound(admin, "open");
            return;
        }
        Scheduler.supplyAsync(() -> Bukkit.getOfflinePlayer((String)targetName)).thenAccept(target -> {
            if (!target.hasPlayedBefore()) {
                admin.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.player-not-found", new TagResolver[]{Placeholder.unparsed((String)"player", (String)targetName)}));
                return;
            }
            this.storage.loadEnderChest(target.getUniqueId()).thenCombine(this.storage.loadEnderChestSize(target.getUniqueId()), (items, size) -> {
                if (items == null || size == 0) {
                    admin.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.player-not-found", new TagResolver[]{Placeholder.unparsed((String)"player", (String)targetName)}));
                    return null;
                }
                Component title = EnderChestUtils.getAdminTitle(target.getName() != null ? target.getName() : targetName);
                Inventory inv = Bukkit.createInventory((InventoryHolder)admin, (int)size, (Component)title);
                inv.setContents(items);
                this.plugin.getEnderChestManager().getAdminViewedChests().put(inv, target.getUniqueId());
                Scheduler.runEntityTask((Entity)admin, () -> {
                    admin.openInventory(inv);
                    this.plugin.getSoundHandler().playSound(admin, "open");
                });
                return null;
            });
        });
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("CustomEnderChest.admin")) {
            sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.no-permission", new TagResolver[0]));
            return;
        }
        this.plugin.config().reload();
        this.plugin.getLocaleManager().loadLocale();
        this.plugin.getDebugLogger().reload();
        sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.reload-success", new TagResolver[0]));
    }

    private void handleImport(CommandSender sender) {
        if (!sender.hasPermission("CustomEnderChest.admin")) {
            sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.no-permission", new TagResolver[0]));
            return;
        }
        this.legacyImporter.runImport(sender);
    }

    private void handleDelete(CommandSender sender, String[] args, String label) {
        if (!sender.hasPermission("CustomEnderChest.command.delete")) {
            sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.no-permission", new TagResolver[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.delete-usage", new TagResolver[]{Placeholder.unparsed((String)"label", (String)label)}));
            return;
        }
        String targetName = args[1];
        Scheduler.supplyAsync(() -> Bukkit.getOfflinePlayer((String)targetName)).thenAccept(target -> {
            if (!target.hasPlayedBefore()) {
                sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.player-not-found", new TagResolver[]{Placeholder.unparsed((String)"player", (String)targetName)}));
                return;
            }
            UUID targetUUID = target.getUniqueId();
            String finalName = target.getName() != null ? target.getName() : targetName;
            DataLockManager dataLockManager = this.plugin.getDataLockManager();
            LocaleManager localeManager = this.plugin.getLocaleManager();
            if (dataLockManager.isLocked(targetUUID)) {
                sender.sendMessage(localeManager.getPrefixedComponent("messages.data-busy", new TagResolver[0]));
                return;
            }
            dataLockManager.lock(targetUUID);
            int size = 0;
            size = target.isOnline() ? EnderChestUtils.getSize(Objects.requireNonNull(target.getPlayer())) : this.storage.loadEnderChestSize(targetUUID).join();
            if (size == 0) {
                sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.delete-success", new TagResolver[]{Placeholder.unparsed((String)"player", (String)finalName)}));
                return;
            }
            ItemStack[] emptyItems = new ItemStack[size];
            this.manager.saveEnderChest(targetUUID, finalName, size, emptyItems).thenRun(() -> {
                if (target.isOnline()) {
                    Scheduler.runEntityTask((Entity)target.getPlayer(), () -> {
                        this.manager.reloadCacheFor(target.getPlayer());
                        Objects.requireNonNull(target.getPlayer()).closeInventory();
                    });
                }
                dataLockManager.unlock(targetUUID);
                sender.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("command.delete-success", new TagResolver[]{Placeholder.unparsed((String)"player", (String)finalName)}));
            });
        });
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("CustomEnderChest.command.open.self")) {
                completions.add("open");
            }
            if (sender.hasPermission("CustomEnderChest.admin")) {
                completions.add("reload");
                completions.add("importlegacy");
                completions.add("delete");
                completions.add("convertall");
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("open") || args[0].equalsIgnoreCase("delete")) && sender.hasPermission("CustomEnderChest.command.open.other")) {
            return null;
        }
        return List.of();
    }
}

