/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.Scheduler;
import org.maiminhdung.customenderchest.locale.LocaleManager;
import org.maiminhdung.customenderchest.utils.DataLockManager;
import org.maiminhdung.customenderchest.utils.EnderChestUtils;
import org.maiminhdung.customenderchest.utils.SoundHandler;

public class EnderChestManager {
    private final EnderChest plugin;
    private final SoundHandler soundHandler;
    private final DataLockManager dataLockManager;
    private final Cache<UUID, Inventory> liveData;
    private final Scheduler.Task autoSaveTask;
    private final Scheduler.Task inventoryTrackerTask;
    private final Map<Inventory, UUID> adminViewedChests = new ConcurrentHashMap<Inventory, UUID>();
    private final Map<UUID, Inventory> openInventories = new ConcurrentHashMap<UUID, Inventory>();
    private final Set<UUID> resizingPlayers = ConcurrentHashMap.newKeySet();
    private final Set<UUID> notifiedOverflowPlayers = ConcurrentHashMap.newKeySet();

    public EnderChestManager(EnderChest plugin) {
        this.plugin = plugin;
        this.soundHandler = plugin.getSoundHandler();
        this.dataLockManager = plugin.getDataLockManager();
        this.liveData = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
        long autoSaveIntervalTicks = (long)plugin.config().getInt("storage.auto-save-interval-seconds", 300) * 20L;
        this.autoSaveTask = autoSaveIntervalTicks > 0L ? Scheduler.runTaskTimerAsync(this::autoSaveAll, autoSaveIntervalTicks, autoSaveIntervalTicks) : null;
        this.inventoryTrackerTask = Scheduler.runTaskTimer(this::checkOpenInventories, 20L, 20L);
    }

    public void onPlayerJoin(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.getLoadedEnderChest(player.getUniqueId()) != null) {
            this.plugin.getDebugLogger().log("Data for " + player.getName() + " is already cached. Skipping load.");
            return;
        }
        if (!this.dataLockManager.lock(player.getUniqueId())) {
            this.plugin.getDebugLogger().log("Attempted to load data for " + player.getName() + ", but their data is currently locked.");
            return;
        }
        this.plugin.getDebugLogger().log("Data lock acquired for " + player.getName() + ". Checking storage...");
        long startTime = System.nanoTime();
        this.plugin.getStorageManager().getStorage().loadEnderChest(player.getUniqueId()).whenComplete((items, error) -> {
            if (!player.isOnline()) {
                this.dataLockManager.unlock(player.getUniqueId());
                return;
            }
            Scheduler.runEntityTask((Entity)player, () -> {
                try {
                    if (error != null) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to load data for " + player.getName(), (Throwable)error);
                        return;
                    }
                    int size = EnderChestUtils.getSize(player);
                    Component title = EnderChestUtils.getTitle(player);
                    Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(size > 0 ? size : 9), (Component)title);
                    boolean hadIncompatibleData = false;
                    if (items != null && ((ItemStack[])items).length == 0) {
                        this.plugin.getStorageManager().getStorage().loadEnderChestSize(player.getUniqueId()).thenAccept(savedSize -> {
                            if (savedSize > 0) {
                                Scheduler.runEntityTask((Entity)player, () -> {
                                    LocaleManager locale = this.plugin.getLocaleManager();
                                    player.sendMessage(locale.getPrefixedComponent("messages.migration-data-incompatible", new TagResolver[0]));
                                    player.sendMessage(locale.getPrefixedComponent("messages.migration-data-cleared", new TagResolver[0]));
                                    player.sendMessage(locale.getPrefixedComponent("messages.migration-contact-admin", new TagResolver[0]));
                                });
                            }
                        });
                    } else if (items != null && size > 0) {
                        boolean hasNullItems = false;
                        for (ItemStack item : items) {
                            if (item != null) continue;
                            hasNullItems = true;
                            break;
                        }
                        if (((ItemStack[])items).length <= size) {
                            inv.setContents(items);
                        } else {
                            for (int i = 0; i < size; ++i) {
                                inv.setItem(i, items[i]);
                            }
                        }
                    }
                    this.liveData.put((Object)player.getUniqueId(), (Object)inv);
                    long duration = (System.nanoTime() - startTime) / 1000000L;
                    this.plugin.getDebugLogger().log("Cache is ready for " + player.getName() + ". (Load time: " + duration + "ms)");
                }
                finally {
                    this.dataLockManager.unlock(player.getUniqueId());
                    this.plugin.getDebugLogger().log("Data lock released for " + player.getName());
                }
            });
        });
    }

    public void onPlayerQuit(Player player) {
        this.openInventories.remove(player.getUniqueId());
        if (!this.dataLockManager.lock(player.getUniqueId())) {
            this.plugin.getDebugLogger().log("Player " + player.getName() + " quit, but data is locked. Skipping quit-save.");
            return;
        }
        this.plugin.getDebugLogger().log("Player " + player.getName() + " quit. Data lock acquired for saving.");
        Inventory inv = (Inventory)this.liveData.getIfPresent((Object)player.getUniqueId());
        if (inv != null) {
            this.saveEnderChest(player.getUniqueId(), player.getName(), inv).whenComplete((v, ex) -> {
                this.liveData.invalidate((Object)player.getUniqueId());
                this.dataLockManager.unlock(player.getUniqueId());
                this.plugin.getDebugLogger().log("Quit-save for " + player.getName() + " complete. Lock released.");
            });
        } else {
            this.dataLockManager.unlock(player.getUniqueId());
        }
    }

    public void shutdown() {
        if (this.autoSaveTask != null) {
            this.autoSaveTask.cancel();
        }
        if (this.inventoryTrackerTask != null) {
            this.inventoryTrackerTask.cancel();
        }
        this.plugin.getLogger().info("Auto-save task cancelled. Saving all cached player data before shutting down...");
        this.shutdownSave().join();
        this.plugin.getLogger().info("All player data has been saved successfully.");
    }

    public void openEnderChest(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.dataLockManager.isLocked(player.getUniqueId())) {
            player.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.data-still-loading", new TagResolver[0]));
            return;
        }
        Inventory inv = this.getLoadedEnderChest(player.getUniqueId());
        if (inv == null) {
            Scheduler.runTaskAsync(() -> {
                if (player.isOnline()) {
                    this.onPlayerJoin(player);
                }
            });
            player.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.data-still-loading", new TagResolver[0]));
            return;
        }
        int permissionSize = EnderChestUtils.getSize(player);
        if (permissionSize == 0) {
            player.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.no-permission", new TagResolver[0]));
            this.soundHandler.playSound(player, "fail");
            return;
        }
        ItemStack[] contents = inv.getContents();
        int lastItemIndex = -1;
        for (int i = contents.length - 1; i >= 0; --i) {
            ItemStack item = contents[i];
            if (item == null || item.getType() == Material.AIR) continue;
            lastItemIndex = i;
            break;
        }
        int expectedDisplaySize = permissionSize;
        if (lastItemIndex >= permissionSize) {
            expectedDisplaySize = (int)Math.ceil((double)(lastItemIndex + 1) / 9.0) * 9;
        }
        expectedDisplaySize = Math.max(permissionSize, expectedDisplaySize);
        if (inv.getSize() != expectedDisplaySize) {
            inv = this.resizeInventory(player, inv, permissionSize);
            this.liveData.put((Object)player.getUniqueId(), (Object)inv);
        }
        player.openInventory(inv);
        this.openInventories.put(player.getUniqueId(), inv);
        this.soundHandler.playSound(player, "open");
    }

    private Inventory resizeInventory(Player player, Inventory oldInv, int newSize) {
        this.plugin.getDebugLogger().log("Resizing " + player.getName() + "'s inventory. Old: " + oldInv.getSize() + ", New Size: " + newSize);
        ItemStack[] oldContents = oldInv.getContents();
        Component title = EnderChestUtils.getTitle(player);
        Inventory newInv = Bukkit.createInventory((InventoryHolder)player, (int)newSize, (Component)title);
        ArrayList<ItemStack> overflowItems = new ArrayList<ItemStack>();
        for (int i = 0; i < oldContents.length; ++i) {
            ItemStack item = oldContents[i];
            if (item == null || item.getType() == Material.AIR) continue;
            if (i < newSize) {
                newInv.setItem(i, item);
                this.plugin.getDebugLogger().log("  Slot " + i + ": Kept item " + String.valueOf(item.getType()));
                continue;
            }
            overflowItems.add(item);
            this.plugin.getDebugLogger().log("  Slot " + i + ": Moved " + String.valueOf(item.getType()) + " to overflow storage");
        }
        if (!overflowItems.isEmpty()) {
            ItemStack[] overflowArray = overflowItems.toArray(new ItemStack[0]);
            this.plugin.getStorageManager().getStorage().saveOverflowItems(player.getUniqueId(), overflowArray).thenRun(() -> {
                this.plugin.getDebugLogger().log("Saved " + overflowItems.size() + " overflow items for " + player.getName());
                if (!this.notifiedOverflowPlayers.contains(player.getUniqueId())) {
                    Scheduler.runEntityTask((Entity)player, () -> {
                        LocaleManager locale = this.plugin.getLocaleManager();
                        player.sendMessage(locale.getPrefixedComponent("messages.overflow-items-saved", new TagResolver[0]));
                        player.sendMessage(locale.getPrefixedComponent("messages.overflow-will-restore", new TagResolver[0]));
                    });
                    this.notifiedOverflowPlayers.add(player.getUniqueId());
                }
            });
        } else {
            this.restoreOverflowItems(player, newInv);
        }
        this.plugin.getDebugLogger().log("Resize complete. New inventory size: " + newInv.getSize() + ", Overflow items: " + overflowItems.size());
        return newInv;
    }

    private void restoreOverflowItems(Player player, Inventory inv) {
        this.plugin.getStorageManager().getStorage().loadOverflowItems(player.getUniqueId()).thenAccept(overflowItems -> {
            if (overflowItems == null || ((ItemStack[])overflowItems).length == 0) {
                return;
            }
            Scheduler.runEntityTask((Entity)player, () -> {
                ArrayList<ItemStack> remainingOverflow = new ArrayList<ItemStack>();
                ArrayList<ItemStack> restoredItems = new ArrayList<ItemStack>();
                for (ItemStack item : overflowItems) {
                    if (item == null || item.getType() == Material.AIR) continue;
                    if (inv.firstEmpty() != -1) {
                        inv.addItem(new ItemStack[]{item});
                        restoredItems.add(item);
                        this.plugin.getDebugLogger().log("Restored overflow item " + String.valueOf(item.getType()) + " to " + player.getName());
                        continue;
                    }
                    remainingOverflow.add(item);
                }
                int count = restoredItems.size();
                if (count > 0) {
                    this.liveData.put((Object)player.getUniqueId(), (Object)inv);
                    LocaleManager locale = this.plugin.getLocaleManager();
                    player.sendMessage(locale.getPrefixedComponent("messages.overflow-items-restored", new TagResolver[0]).replaceText(builder -> builder.matchLiteral("<count>").replacement(String.valueOf(count))));
                }
                if (remainingOverflow.isEmpty()) {
                    this.plugin.getStorageManager().getStorage().clearOverflowItems(player.getUniqueId());
                    this.notifiedOverflowPlayers.remove(player.getUniqueId());
                } else {
                    ItemStack[] remaining = remainingOverflow.toArray(new ItemStack[0]);
                    this.plugin.getStorageManager().getStorage().saveOverflowItems(player.getUniqueId(), remaining);
                }
            });
        });
    }

    private CompletableFuture<Void> shutdownSave() {
        HashSet cacheSnapshot = new HashSet(this.liveData.asMap().entrySet());
        if (cacheSnapshot.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.plugin.getLogger().info("Force-saving data for " + cacheSnapshot.size() + " players...");
        CompletableFuture[] futures = (CompletableFuture[])cacheSnapshot.stream().map(entry -> {
            UUID uuid = (UUID)entry.getKey();
            Player p = Bukkit.getPlayer((UUID)uuid);
            String name = p != null ? p.getName() : Bukkit.getOfflinePlayer((UUID)uuid).getName();
            return this.saveEnderChest(uuid, name, (Inventory)entry.getValue());
        }).filter(Objects::nonNull).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private CompletableFuture<Void> autoSaveAll() {
        HashSet cacheSnapshot = new HashSet(this.liveData.asMap().entrySet());
        if (cacheSnapshot.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.plugin.getDebugLogger().log("Auto-saving data for " + cacheSnapshot.size() + " online players...");
        CompletableFuture[] futures = (CompletableFuture[])cacheSnapshot.stream().map(entry -> {
            UUID uuid = (UUID)entry.getKey();
            if (this.dataLockManager.isLocked(uuid)) {
                return null;
            }
            Player p = Bukkit.getPlayer((UUID)uuid);
            String name = p != null ? p.getName() : null;
            return this.saveEnderChest(uuid, name, (Inventory)entry.getValue());
        }).filter(Objects::nonNull).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    public CompletableFuture<Void> saveEnderChest(UUID uuid, String playerName, Inventory inv) {
        long startTime = System.nanoTime();
        ItemStack[] cleanedContents = this.cleanInventoryForSave(inv.getContents());
        return this.plugin.getStorageManager().getStorage().saveEnderChest(uuid, playerName, inv.getSize(), cleanedContents).thenRun(() -> {
            long duration = (System.nanoTime() - startTime) / 1000000L;
            this.plugin.getDebugLogger().log("Data for " + playerName + " saved in " + duration + "ms.");
        });
    }

    private ItemStack[] cleanInventoryForSave(ItemStack[] contents) {
        ItemStack[] cleaned = new ItemStack[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            cleaned[i] = item == null || item.getType() == Material.AIR ? null : item;
        }
        return cleaned;
    }

    public CompletableFuture<Void> saveEnderChest(UUID uuid, String playerName, int size, ItemStack[] items) {
        return this.plugin.getStorageManager().getStorage().saveEnderChest(uuid, playerName, size, items);
    }

    public Inventory getLoadedEnderChest(UUID uuid) {
        return (Inventory)this.liveData.getIfPresent((Object)uuid);
    }

    private void checkOpenInventories() {
        if (this.openInventories.isEmpty()) {
            return;
        }
        for (UUID uuid : new ArrayList<UUID>(this.openInventories.keySet())) {
            boolean titleMismatched;
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline() || player.getOpenInventory().getTopInventory() != this.openInventories.get(uuid)) {
                this.openInventories.remove(uuid);
                this.resizingPlayers.remove(uuid);
                continue;
            }
            if (this.resizingPlayers.contains(uuid)) continue;
            Inventory openInv = this.openInventories.get(uuid);
            int currentPermissionSize = EnderChestUtils.getSize(player);
            Inventory cachedInv = (Inventory)this.liveData.getIfPresent((Object)uuid);
            if (cachedInv == null) continue;
            ItemStack[] contents = cachedInv.getContents();
            int lastItemIndex = -1;
            for (int i = contents.length - 1; i >= 0; --i) {
                ItemStack item = contents[i];
                if (item == null || item.getType() == Material.AIR) continue;
                lastItemIndex = i;
                break;
            }
            int expectedDisplaySize = currentPermissionSize;
            if (lastItemIndex >= currentPermissionSize) {
                expectedDisplaySize = (int)Math.ceil((double)(lastItemIndex + 1) / 9.0) * 9;
            }
            expectedDisplaySize = Math.max(currentPermissionSize, expectedDisplaySize);
            boolean sizeMismatched = cachedInv.getSize() != expectedDisplaySize;
            Component expectedTitleComponent = EnderChestUtils.getTitle(player);
            Component actualTitleComponent = player.getOpenInventory().title();
            String expectedTitle = LegacyComponentSerializer.legacySection().serialize(expectedTitleComponent);
            String actualTitle = LegacyComponentSerializer.legacySection().serialize(actualTitleComponent);
            boolean bl = titleMismatched = !expectedTitle.equals(actualTitle);
            if (!sizeMismatched && !titleMismatched) continue;
            this.plugin.getDebugLogger().log("State change for " + player.getName() + ". Refreshing inventory. Size mismatch: " + sizeMismatched + ", Title mismatch: " + titleMismatched);
            this.resizingPlayers.add(uuid);
            this.openInventories.remove(uuid);
            ItemStack cursorItem = player.getItemOnCursor();
            player.setItemOnCursor(null);
            player.closeInventory();
            Inventory resizedInv = this.resizeInventory(player, cachedInv, currentPermissionSize);
            this.liveData.put((Object)uuid, (Object)resizedInv);
            this.plugin.getDebugLogger().log("Resized inventory cached. New size: " + resizedInv.getSize() + ", Expected: " + expectedDisplaySize);
            Scheduler.runTaskLater(() -> {
                if (player.isOnline()) {
                    player.openInventory(resizedInv);
                    this.openInventories.put(uuid, resizedInv);
                    this.soundHandler.playSound(player, "open");
                    player.setItemOnCursor(cursorItem);
                }
                Scheduler.runTaskLater(() -> this.resizingPlayers.remove(uuid), 5L);
            }, 2L);
        }
    }

    public void reloadCacheFor(Player player) {
        int size = EnderChestUtils.getSize(player);
        if (size == 0) {
            this.liveData.invalidate((Object)player.getUniqueId());
            return;
        }
        Component title = EnderChestUtils.getTitle(player);
        Inventory newInv = Bukkit.createInventory((InventoryHolder)player, (int)size, (Component)title);
        this.liveData.put((Object)player.getUniqueId(), (Object)newInv);
        this.plugin.getDebugLogger().log("Cache reloaded for player " + player.getName());
    }

    @Generated
    public Map<Inventory, UUID> getAdminViewedChests() {
        return this.adminViewedChests;
    }

    @Generated
    public Map<UUID, Inventory> getOpenInventories() {
        return this.openInventories;
    }
}

