/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.utils.Text;

public final class ItemSerializer {
    private static final Logger LOGGER = Logger.getLogger(ItemSerializer.class.getName());

    public static String toBase64(ItemStack[] items) throws IOException {
        if (items == null || items.length == 0) {
            return "";
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dataOutput = new DataOutputStream(outputStream);){
                dataOutput.writeInt(items.length);
                for (ItemStack item : items) {
                    if (item == null || item.getType().isAir()) {
                        dataOutput.writeBoolean(false);
                        continue;
                    }
                    dataOutput.writeBoolean(true);
                    byte[] itemBytes = item.serializeAsBytes();
                    dataOutput.writeInt(itemBytes.length);
                    dataOutput.write(itemBytes);
                }
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            }
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    public static ItemStack[] fromBase64(String data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ItemStack[] deserializeNewFormat(byte[] bytes) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            ItemStack[] itemStackArray;
            try (DataInputStream dataInput = new DataInputStream(inputStream);){
                int length = dataInput.readInt();
                if (length < 0 || length > 256) {
                    throw new IOException("Invalid array length: " + length);
                }
                ItemStack[] items = new ItemStack[length];
                for (int i = 0; i < length; ++i) {
                    boolean hasItem = dataInput.readBoolean();
                    if (hasItem) {
                        int itemBytesLength = dataInput.readInt();
                        if (itemBytesLength < 0 || itemBytesLength > 1000000) {
                            LOGGER.log(Level.WARNING, "Invalid item data size at slot " + i + ": " + itemBytesLength + ", skipping item");
                            items[i] = null;
                            continue;
                        }
                        byte[] itemBytes = new byte[itemBytesLength];
                        dataInput.readFully(itemBytes);
                        try {
                            items[i] = ItemStack.deserializeBytes((byte[])itemBytes);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to deserialize item at slot " + i + ": " + e.getMessage());
                            items[i] = null;
                        }
                        continue;
                    }
                    items[i] = null;
                }
                itemStackArray = items;
            }
            return itemStackArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ItemStack[] deserializeLegacyFormat(byte[] bytes) throws IOException {
        LOGGER.log(Level.WARNING, "=================================================================");
        LOGGER.log(Level.WARNING, "Detected legacy data format - attempting migration...");
        LOGGER.log(Level.WARNING, "=================================================================");
        ItemSerializer.notifyOpsAboutLegacyData();
        try {
            Object obj;
            block21: {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                BukkitObjectInputStream objectInput = new BukkitObjectInputStream((InputStream)inputStream);
                obj = objectInput.readObject();
                if (!(obj instanceof ItemStack[])) {
                    Object object;
                    if (obj != null) {
                        object = obj.getClass();
                        throw new IOException("Unexpected object type in legacy data: " + String.valueOf(object));
                    }
                    object = "null";
                    throw new IOException("Unexpected object type in legacy data: " + String.valueOf(object));
                }
                break block21;
                finally {
                    objectInput.close();
                }
                finally {
                    inputStream.close();
                }
            }
            ItemStack[] legacyItems = (ItemStack[])obj;
            LOGGER.log(Level.INFO, "Successfully loaded " + legacyItems.length + " slots from legacy format");
            int successCount = 0;
            int nullCount = 0;
            ItemStack[] itemStackArray = legacyItems;
            int n = itemStackArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    LOGGER.log(Level.INFO, "Legacy migration completed: " + successCount + " items loaded, " + nullCount + " empty slots");
                    itemStackArray = legacyItems;
                    return itemStackArray;
                }
                ItemStack item = itemStackArray[n2];
                if (item != null) {
                    ++successCount;
                } else {
                    ++nullCount;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException during legacy migration", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "=================================================================");
            LOGGER.log(Level.SEVERE, "FAILED TO MIGRATE LEGACY DATA FROM <1.21.4 TO 1.21.5+");
            LOGGER.log(Level.SEVERE, "=================================================================");
            LOGGER.log(Level.SEVERE, "This error occurs because item component format changed between");
            LOGGER.log(Level.SEVERE, "Minecraft <1.21.4 and 1.21.5, making old data incompatible.");
            LOGGER.log(Level.SEVERE, "");
            LOGGER.log(Level.SEVERE, "TO FIX THIS ISSUE:");
            LOGGER.log(Level.SEVERE, "1. Downgrade your server back to <1.21.4");
            LOGGER.log(Level.SEVERE, "2. Install this plugin on <1.21.4 server");
            LOGGER.log(Level.SEVERE, "3. Run command: /cec convertall");
            LOGGER.log(Level.SEVERE, "4. Wait for conversion to complete");
            LOGGER.log(Level.SEVERE, "5. Then upgrade server to 1.21.5+");
            LOGGER.log(Level.SEVERE, "");
            LOGGER.log(Level.SEVERE, "CURRENT STATUS:");
            LOGGER.log(Level.SEVERE, "Player will receive EMPTY enderchest.");
            LOGGER.log(Level.SEVERE, "Old data is preserved in database but cannot be loaded.");
            LOGGER.log(Level.SEVERE, "=================================================================");
            LOGGER.log(Level.SEVERE, "Error details:", e);
            ItemSerializer.notifyOpsAboutConversionFailure();
            return new ItemStack[0];
        }
    }

    private static void notifyOpsAboutLegacyData() {
        try {
            Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("CustomEnderChest"), () -> {
                EnderChest plugin = (EnderChest)Bukkit.getPluginManager().getPlugin("CustomEnderChest");
                if (plugin == null) {
                    return;
                }
                Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(op -> {
                    Component prefix = plugin.getLocaleManager().getComponent("prefix", new TagResolver[0]);
                    op.sendMessage(prefix.append(Text.parse("<bold><red>WARNING!", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<gold>Detected legacy data format in database!", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<gold>This data was saved on an older Minecraft version.", new TagResolver[0])));
                    op.sendMessage(prefix);
                    op.sendMessage(prefix.append(Text.parse("<bold><red>IMPORTANT:", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<gold>If you're on 1.21.4: Run <yellow>/cec convertall</yellow> to convert all data", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<gold>If you're on 1.21.5+: Downgrade to 1.21.4, run conversion, then upgrade", new TagResolver[0])));
                    op.sendMessage(prefix);
                    op.sendMessage(prefix.append(Text.parse("<gold>Without conversion, players may lose their items!", new TagResolver[0])));
                });
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void notifyOpsAboutConversionFailure() {
        try {
            Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("CustomEnderChest"), () -> {
                EnderChest plugin = (EnderChest)Bukkit.getPluginManager().getPlugin("CustomEnderChest");
                if (plugin == null) {
                    return;
                }
                Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(op -> {
                    Component prefix = plugin.getLocaleManager().getComponent("prefix", new TagResolver[0]);
                    op.sendMessage(prefix.append(Text.parse("<bold><dark_red>CRITICAL ERROR!", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<red>Failed to migrate player data from old format!", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<red>Player received empty enderchest.", new TagResolver[0])));
                    op.sendMessage(prefix);
                    op.sendMessage(prefix.append(Text.parse("<bold><yellow>TO FIX:", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<yellow>1. Downgrade server to 1.21.4", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<yellow>2. Run: /cec convertall", new TagResolver[0])));
                    op.sendMessage(prefix.append(Text.parse("<yellow>3. Then upgrade to 1.21.5+", new TagResolver[0])));
                });
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<Map<String, Object>> serialize(ItemStack[] items) {
        return Stream.of(items).map(item -> item != null && !item.getType().isAir() ? item.serialize() : null).collect(Collectors.toList());
    }

    public static ItemStack[] deserialize(List<Map<String, Object>> mapList) {
        if (mapList == null) {
            return new ItemStack[0];
        }
        return (ItemStack[])mapList.stream().map(map -> map != null ? ItemStack.deserialize((Map)map) : null).toArray(ItemStack[]::new);
    }
}

