/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.listeners;

import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.Scheduler;
import org.maiminhdung.customenderchest.data.EnderChestManager;
import org.maiminhdung.customenderchest.locale.LocaleManager;
import org.maiminhdung.customenderchest.utils.DataLockManager;
import org.maiminhdung.customenderchest.utils.DebugLogger;
import org.maiminhdung.customenderchest.utils.EnderChestUtils;

public class PlayerListener
implements Listener {
    private final EnderChest plugin;
    private final DebugLogger debug;

    public PlayerListener(EnderChest plugin) {
        this.plugin = plugin;
        this.debug = plugin.getDebugLogger();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent event) {
        this.plugin.getEnderChestManager().onPlayerJoin(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.plugin.getEnderChestManager().onPlayerQuit(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnderChestInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.ENDER_CHEST) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (player == null || !player.isOnline()) {
            return;
        }
        this.plugin.getEnderChestManager().openEnderChest(player);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryClick(InventoryClickEvent event) {
        int permissionSize;
        int slot;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory clickedInv = event.getInventory();
        if (clickedInv == null) {
            return;
        }
        EnderChestManager manager = this.plugin.getEnderChestManager();
        Inventory cachedInv = manager.getLoadedEnderChest(player.getUniqueId());
        if (cachedInv != null && clickedInv.equals((Object)cachedInv) && (slot = event.getRawSlot()) >= (permissionSize = EnderChestUtils.getSize(player)) && slot < clickedInv.getSize()) {
            event.setCancelled(true);
            player.sendMessage(this.plugin.getLocaleManager().getComponent("messages.slot-locked", new TagResolver[0]));
            this.plugin.getSoundHandler().playSound(player, "fail");
        }
        this.onAdminInventoryClick(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAdminInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player admin = (Player)humanEntity;
        if (event.isCancelled()) {
            return;
        }
        Inventory clickedInv = event.getInventory();
        EnderChestManager manager = this.plugin.getEnderChestManager();
        UUID targetUuid = manager.getAdminViewedChests().get(clickedInv);
        if (targetUuid == null) {
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((UUID)targetUuid);
        if (targetPlayer != null && targetPlayer.isOnline()) {
            Scheduler.runTaskLater(() -> {
                Inventory targetLiveInv = manager.getLoadedEnderChest(targetUuid);
                if (targetLiveInv != null) {
                    targetLiveInv.setContents(clickedInv.getContents());
                    this.debug.log("Real-time sync: Admin " + admin.getName() + " modified " + targetPlayer.getName() + "'s enderchest");
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!player.isOnline()) {
            return;
        }
        EnderChestManager manager = this.plugin.getEnderChestManager();
        Inventory closedInventory = event.getInventory();
        if (closedInventory == null) {
            return;
        }
        LocaleManager localeManager = this.plugin.getLocaleManager();
        manager.getOpenInventories().remove(player.getUniqueId());
        if (manager.getAdminViewedChests().containsKey(closedInventory)) {
            UUID targetUUID = manager.getAdminViewedChests().remove(closedInventory);
            if (targetUUID == null) {
                return;
            }
            DataLockManager dataLockManager = this.plugin.getDataLockManager();
            if (dataLockManager.isLocked(targetUUID)) {
                player.sendMessage(localeManager.getPrefixedComponent("messages.data-still-loading", new TagResolver[0]));
                return;
            }
            dataLockManager.lock(targetUUID);
            try {
                String targetName;
                this.debug.log("Admin " + player.getName() + " finished editing " + String.valueOf(targetUUID) + "'s chest. Saving data...");
                Player targetPlayer = Bukkit.getPlayer((UUID)targetUUID);
                if (targetPlayer != null && targetPlayer.isOnline()) {
                    targetName = targetPlayer.getName();
                    Inventory targetLiveInv = manager.getLoadedEnderChest(targetUUID);
                    if (targetLiveInv != null) {
                        targetLiveInv.setContents(closedInventory.getContents());
                        this.debug.log("Final sync completed for online player: " + targetName);
                    }
                } else {
                    targetName = Bukkit.getOfflinePlayer((UUID)targetUUID).getName();
                }
                String finalTargetName = targetName;
                Scheduler.runTaskAsync(() -> {
                    try {
                        manager.saveEnderChest(targetUUID, finalTargetName, closedInventory).join();
                        this.debug.log("Data for player " + finalTargetName + " saved successfully by admin.");
                    }
                    finally {
                        dataLockManager.unlock(targetUUID);
                    }
                });
                this.plugin.getSoundHandler().playSound(player, "close");
            }
            catch (Exception e) {
                dataLockManager.unlock(targetUUID);
                player.sendMessage(localeManager.getPrefixedComponent("messages.save-error", new TagResolver[0]));
                e.printStackTrace();
            }
            return;
        }
        Inventory cachedInv = manager.getLoadedEnderChest(player.getUniqueId());
        if (closedInventory.equals((Object)cachedInv)) {
            this.plugin.getSoundHandler().playSound(player, "close");
        }
    }
}

