/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.storage.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.inventory.ItemStack;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.data.ItemSerializer;
import org.maiminhdung.customenderchest.storage.StorageInterface;
import org.maiminhdung.customenderchest.storage.StorageManager;

public class H2Storage
implements StorageInterface {
    private final StorageManager storageManager;
    private final String tableName;

    public H2Storage(StorageManager storageManager) {
        this.storageManager = storageManager;
        this.tableName = EnderChest.getInstance().config().getString("storage.table_name", "custom_enderchests");
    }

    @Override
    public void init() {
        CompletableFuture.runAsync(() -> {
            String sql = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (player_uuid VARCHAR(36) NOT NULL PRIMARY KEY,player_name VARCHAR(16),chest_size INT NOT NULL,chest_data LONGTEXT,last_seen BIGINT NOT NULL)";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.executeUpdate();
            }
            catch (Exception e) {
                EnderChest.getInstance().getLogger().severe("Failed to initialize H2 table!");
                e.printStackTrace();
            }
            String overflowSql = "CREATE TABLE IF NOT EXISTS " + this.tableName + "_overflow (player_uuid VARCHAR(36) NOT NULL PRIMARY KEY,overflow_data LONGTEXT,created_at BIGINT NOT NULL)";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(overflowSql);){
                ps.executeUpdate();
                EnderChest.getInstance().getLogger().info("Overflow storage table initialized successfully.");
            }
            catch (Exception e) {
                EnderChest.getInstance().getLogger().severe("Failed to initialize overflow table!");
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<ItemStack[]> loadEnderChest(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private void autoSaveMigratedData(UUID playerUUID, String newData) {
        CompletableFuture.runAsync(() -> {
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement("UPDATE " + this.tableName + " SET chest_data = ? WHERE player_uuid = ?");){
                ps.setString(1, newData);
                ps.setString(2, playerUUID.toString());
                ps.executeUpdate();
            }
            catch (Exception e) {
                EnderChest.getInstance().getLogger().warning("Failed to auto-save migrated data: " + e.getMessage());
            }
        });
    }

    @Override
    public CompletableFuture<Integer> loadEnderChestSize(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT chest_size FROM " + this.tableName + " WHERE player_uuid = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return 0;
                Integer n = rs.getInt("chest_size");
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        });
    }

    @Override
    public CompletableFuture<Void> saveEnderChest(UUID playerUUID, String playerName, int size, ItemStack[] items) {
        return CompletableFuture.runAsync(() -> {
            String sql = "MERGE INTO " + this.tableName + " (player_uuid, player_name, chest_size, chest_data, last_seen) KEY(player_uuid) VALUES(?, ?, ?, ?, ?)";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                String data = ItemSerializer.toBase64(items);
                ps.setString(1, playerUUID.toString());
                ps.setString(2, playerName);
                ps.setInt(3, size);
                ps.setString(4, data);
                ps.setLong(5, System.currentTimeMillis());
                ps.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<Void> deleteEnderChest(UUID playerUUID) {
        return CompletableFuture.runAsync(() -> {
            String sql = "DELETE FROM " + this.tableName + " WHERE player_uuid = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ps.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<String> getPlayerName(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT player_name FROM " + this.tableName + " WHERE player_uuid = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return null;
                String string = rs.getString("player_name");
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> saveOverflowItems(UUID playerUUID, ItemStack[] items) {
        return CompletableFuture.runAsync(() -> {
            String sql = "MERGE INTO " + this.tableName + "_overflow (player_uuid, overflow_data, created_at) KEY(player_uuid) VALUES(?, ?, ?)";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                String data = ItemSerializer.toBase64(items);
                ps.setString(1, playerUUID.toString());
                ps.setString(2, data);
                ps.setLong(3, System.currentTimeMillis());
                ps.executeUpdate();
            }
            catch (Exception e) {
                EnderChest.getInstance().getLogger().severe("Failed to save overflow items for " + String.valueOf(playerUUID));
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<ItemStack[]> loadOverflowItems(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public CompletableFuture<Void> clearOverflowItems(UUID playerUUID) {
        return CompletableFuture.runAsync(() -> {
            String sql = "DELETE FROM " + this.tableName + "_overflow WHERE player_uuid = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ps.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> hasOverflowItems(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT COUNT(*) FROM " + this.tableName + "_overflow WHERE player_uuid = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return false;
                Boolean bl = rs.getInt(1) > 0;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        });
    }
}

