/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.utils;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.utils.Text;

public class EnderChestUtils {
    private static final EnderChest plugin = EnderChest.getInstance();

    public static int getSize(Player player) {
        int defaultSize;
        int[] validLevels;
        if (player == null) {
            return 0;
        }
        if (player.hasPermission("CustomEnderChest.level.*")) {
            return 54;
        }
        for (int level : validLevels = new int[]{54, 45, 36, 27, 18, 9}) {
            if (!player.hasPermission("CustomEnderChest.level." + (level / 9 - 1))) continue;
            return level;
        }
        for (int i = 5; i >= 0; --i) {
            if (!player.hasPermission("CustomEnderChest.level." + i)) continue;
            return (i + 1) * 9;
        }
        if (plugin.config().getBoolean("default-player.enabled") && (defaultSize = plugin.config().getInt("default-player.size", 0)) > 0 && defaultSize % 9 == 0 && defaultSize <= 54) {
            return defaultSize;
        }
        return 0;
    }

    public static Component getTitle(Player player) {
        if (player == null) {
            return Component.text((String)"Invalid Player");
        }
        int size = EnderChestUtils.getSize(player);
        int levelIndex = size > 0 ? size / 9 - 1 : 0;
        String levelNameRaw = plugin.getLocaleManager().getRawString("levels." + levelIndex, "Level " + (levelIndex + 1));
        Component levelComponent = Text.parse(levelNameRaw, new TagResolver[0]);
        String titleFormat = plugin.getLocaleManager().getRawString("titles.enderchest", "<level> - <light_purple><player>'s Chest");
        return Text.parse(titleFormat, new TagResolver[]{Placeholder.component((String)"level", (ComponentLike)levelComponent), Placeholder.unparsed((String)"player", (String)player.getName())});
    }

    public static Component getAdminTitle(String targetName) {
        if (targetName == null || targetName.trim().isEmpty()) {
            targetName = "Unknown Player";
        }
        String titleFormat = plugin.getLocaleManager().getRawString("titles.admin_view", "<dark_red>Admin View: <player>");
        return Text.parse(titleFormat, new TagResolver[]{Placeholder.unparsed((String)"player", (String)targetName)});
    }
}

