/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.Scheduler;
import org.maiminhdung.customenderchest.utils.DebugLogger;
import org.maiminhdung.customenderchest.utils.EnderChestUtils;
import org.maiminhdung.customenderchest.utils.SoundHandler;

public class EnderChestManager {
    private final EnderChest plugin;
    private final SoundHandler soundHandler;
    private final Cache<UUID, Inventory> liveData;
    private final Scheduler.Task autoSaveTask;
    private final Map<Inventory, UUID> adminViewedChests = new HashMap<Inventory, UUID>();
    private final DebugLogger debug;

    public EnderChestManager(EnderChest plugin) {
        this.plugin = plugin;
        this.soundHandler = plugin.getSoundHandler();
        this.debug = plugin.getDebugLogger();
        this.liveData = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
        long autoSaveIntervalTicks = (long)plugin.config().getInt("storage.auto-save-interval-seconds", 300) * 20L;
        this.autoSaveTask = autoSaveIntervalTicks > 0L ? Scheduler.runTaskTimerAsync(this::autoSaveAll, autoSaveIntervalTicks, autoSaveIntervalTicks) : null;
    }

    public void onPlayerJoin(Player player) {
        this.debug.log("Player " + player.getName() + " is joining. Starting to load data...");
        this.plugin.getStorageManager().getStorage().loadEnderChest(player.getUniqueId()).thenAccept(items -> Scheduler.runEntityTask((Entity)player, () -> {
            int size = EnderChestUtils.getSize(player);
            if (size == 0) {
                return;
            }
            Component title = EnderChestUtils.getTitle(player);
            Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (Component)title);
            if (items != null && ((ItemStack[])items).length > 0) {
                if (((ItemStack[])items).length <= size) {
                    inv.setContents(items);
                } else {
                    for (int i = 0; i < size; ++i) {
                        inv.setItem(i, items[i]);
                    }
                }
            }
            this.liveData.put((Object)player.getUniqueId(), (Object)inv);
            this.debug.log("Data for " + player.getName() + " loaded into cache. Size: " + size);
        }));
    }

    public void onPlayerQuit(Player player) {
        Inventory inv = (Inventory)this.liveData.getIfPresent((Object)player.getUniqueId());
        if (inv != null) {
            this.debug.log("Player " + player.getName() + " is quitting. Saving data...");
            this.saveEnderChest(player.getUniqueId(), player.getName(), inv).thenRun(() -> {
                this.liveData.invalidate((Object)player.getUniqueId());
                this.debug.log("Data for " + player.getName() + " saved and removed from cache.");
            });
        }
    }

    public void openEnderChest(Player player) {
        int size = EnderChestUtils.getSize(player);
        if (size == 0) {
            player.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.no-permission", new TagResolver[0]));
            this.soundHandler.playSound(player, "fail");
            return;
        }
        Inventory inv = (Inventory)this.liveData.getIfPresent((Object)player.getUniqueId());
        if (inv == null) {
            player.sendMessage(this.plugin.getLocaleManager().getPrefixedComponent("messages.data-still-loading", new TagResolver[0]));
            return;
        }
        if (inv.getSize() != size) {
            inv = this.resizeInventory(inv, size, player);
            this.liveData.put((Object)player.getUniqueId(), (Object)inv);
        }
        player.openInventory(inv);
        this.plugin.getSoundHandler().playSound(player, "open");
    }

    private Inventory resizeInventory(Inventory oldInv, int newSize, Player holder) {
        Component title = EnderChestUtils.getTitle(holder);
        Inventory newInv = Bukkit.createInventory((InventoryHolder)holder, (int)newSize, (Component)title);
        int copyLimit = Math.min(oldInv.getSize(), newSize);
        for (int i = 0; i < copyLimit; ++i) {
            newInv.setItem(i, oldInv.getItem(i));
        }
        return newInv;
    }

    public void reloadCacheFor(Player player) {
        int size = EnderChestUtils.getSize(player);
        if (size == 0) {
            this.liveData.invalidate((Object)player.getUniqueId());
            return;
        }
        Component title = EnderChestUtils.getTitle(player);
        Inventory newInv = Bukkit.createInventory((InventoryHolder)player, (int)size, (Component)title);
        this.liveData.put((Object)player.getUniqueId(), (Object)newInv);
        this.debug.log("Cache reloaded for player " + player.getName());
    }

    public CompletableFuture<Void> saveEnderChest(UUID uuid, String playerName, Inventory inv) {
        return this.plugin.getStorageManager().getStorage().saveEnderChest(uuid, playerName, inv.getSize(), inv.getContents());
    }

    public CompletableFuture<Void> saveEnderChest(UUID uuid, String playerName, int size, ItemStack[] items) {
        return this.plugin.getStorageManager().getStorage().saveEnderChest(uuid, playerName, size, items);
    }

    public Inventory getLoadedEnderChest(UUID uuid) {
        return (Inventory)this.liveData.getIfPresent((Object)uuid);
    }

    public void shutdown() {
        if (this.autoSaveTask != null) {
            this.autoSaveTask.cancel();
        }
        this.plugin.getLogger().info("Auto-save task cancelled. Saving all online players' data...");
        this.autoSaveAll().join();
        this.plugin.getLogger().info("All player data has been saved.");
    }

    private CompletableFuture<Void> autoSaveAll() {
        HashSet cacheSnapshot = new HashSet(this.liveData.asMap().entrySet());
        if (cacheSnapshot.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.debug.log("Auto-saving data for " + cacheSnapshot.size() + " online players...");
        CompletableFuture[] futures = (CompletableFuture[])cacheSnapshot.stream().map(entry -> {
            UUID uuid = (UUID)entry.getKey();
            Inventory inv = (Inventory)entry.getValue();
            Player p = Bukkit.getPlayer((UUID)uuid);
            String name = p != null ? p.getName() : null;
            return this.saveEnderChest(uuid, name, inv);
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    public Map<Inventory, UUID> getAdminViewedChests() {
        return this.adminViewedChests;
    }
}

