/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public final class ItemSerializer {
    public static String toBase64(ItemStack[] items) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)items);
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            }
            return string;
        }
    }

    public static ItemStack[] fromBase64(String data) throws IOException, ClassNotFoundException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));){
            ItemStack[] itemStackArray;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                itemStackArray = (ItemStack[])dataInput.readObject();
            }
            return itemStackArray;
        }
    }

    public static List<Map<String, Object>> serialize(ItemStack[] items) {
        return Stream.of(items).map(item -> item != null ? item.serialize() : null).collect(Collectors.toList());
    }

    public static ItemStack[] deserialize(List<Map<String, Object>> mapList) {
        if (mapList == null) {
            return new ItemStack[0];
        }
        return (ItemStack[])mapList.stream().map(map -> map != null ? ItemStack.deserialize((Map)map) : null).toArray(ItemStack[]::new);
    }
}

