/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.lib.h2.table;

import java.util.ArrayList;
import org.maiminhdung.customenderchest.lib.h2.engine.SessionLocal;
import org.maiminhdung.customenderchest.lib.h2.index.Index;
import org.maiminhdung.customenderchest.lib.h2.index.IndexType;
import org.maiminhdung.customenderchest.lib.h2.message.DbException;
import org.maiminhdung.customenderchest.lib.h2.result.Row;
import org.maiminhdung.customenderchest.lib.h2.schema.Schema;
import org.maiminhdung.customenderchest.lib.h2.table.IndexColumn;
import org.maiminhdung.customenderchest.lib.h2.table.Table;
import org.maiminhdung.customenderchest.lib.h2.table.TableType;
import org.maiminhdung.customenderchest.lib.h2.util.ParserUtil;

public abstract class VirtualTable
extends Table {
    protected VirtualTable(Schema schema, int n, String string) {
        super(schema, n, string, false, true);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        return ParserUtil.quoteIdentifier(stringBuilder, this.getName(), n);
    }

    @Override
    public void close(SessionLocal sessionLocal) {
    }

    @Override
    public Index addIndex(SessionLocal sessionLocal, String string, int n, IndexColumn[] indexColumnArray, int n2, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public void removeRow(SessionLocal sessionLocal, Row row) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public long truncate(SessionLocal sessionLocal) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public void addRow(SessionLocal sessionLocal, Row row) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public boolean canReference() {
        return false;
    }

    @Override
    public boolean canDrop() {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("Virtual table");
    }
}

